# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.annotations_defaults import AnnotationsDefaults
from runai.models.image_pull_secrets_defaults import ImagePullSecretsDefaults
from runai.models.labels_defaults import LabelsDefaults
from runai.models.tolerations_defaults import TolerationsDefaults
from typing import Optional, Set
from typing_extensions import Self


class AdvancedItemizedDefaults(BaseModel):
    """
    Pydantic class model representing AdvancedItemizedDefaults.

    Parameters:
        ```python
        annotations: Optional[AnnotationsDefaults]
        labels: Optional[LabelsDefaults]
        image_pull_secrets: Optional[ImagePullSecretsDefaults]
        tolerations: Optional[TolerationsDefaults]
        ```
        annotations: See model AnnotationsDefaults for more information.
        labels: See model LabelsDefaults for more information.
        image_pull_secrets: See model ImagePullSecretsDefaults for more information.
        tolerations: See model TolerationsDefaults for more information.
    Example:
        ```python
        AdvancedItemizedDefaults(
            annotations=runai.models.annotations_defaults.AnnotationsDefaults(
                    instances = [
                        runai.models.annotation.Annotation(
                            name = 'billing',
                            value = 'my-billing-unit',
                            exclude = False, )
                        ], ),
                        labels=runai.models.labels_defaults.LabelsDefaults(
                    instances = [
                        runai.models.label.Label(
                            name = 'stage',
                            value = 'initial-research',
                            exclude = False, )
                        ], ),
                        image_pull_secrets=runai.models.image_pull_secrets_defaults.ImagePullSecretsDefaults(
                    instances = [
                        runai.models.image_pull_secret.ImagePullSecret(
                            name = '',
                            user_credential = True,
                            exclude = False, )
                        ], ),
                        tolerations=runai.models.tolerations_defaults.TolerationsDefaults(
                    attributes = runai.models.toleration.Toleration(
                        name = '0',
                        operator = 'Equal',
                        key = '',
                        value = '',
                        effect = 'NoSchedule',
                        seconds = 1,
                        exclude = False, ),
                    instances = [
                        runai.models.toleration.Toleration(
                            name = '0',
                            key = '',
                            value = '',
                            seconds = 1,
                            exclude = False, )
                        ], )
        )
        ```
    """  # noqa: E501

    annotations: Optional[AnnotationsDefaults] = None
    labels: Optional[LabelsDefaults] = None
    image_pull_secrets: Optional[ImagePullSecretsDefaults] = Field(
        default=None, alias="imagePullSecrets"
    )
    tolerations: Optional[TolerationsDefaults] = None
    __properties: ClassVar[List[str]] = [
        "annotations",
        "labels",
        "imagePullSecrets",
        "tolerations",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvancedItemizedDefaults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of annotations
        if self.annotations:
            _dict["annotations"] = self.annotations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of labels
        if self.labels:
            _dict["labels"] = self.labels.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image_pull_secrets
        if self.image_pull_secrets:
            _dict["imagePullSecrets"] = self.image_pull_secrets.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tolerations
        if self.tolerations:
            _dict["tolerations"] = self.tolerations.to_dict()
        # set to None if annotations (nullable) is None
        # and model_fields_set contains the field
        if self.annotations is None and "annotations" in self.model_fields_set:
            _dict["annotations"] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict["labels"] = None

        # set to None if image_pull_secrets (nullable) is None
        # and model_fields_set contains the field
        if (
            self.image_pull_secrets is None
            and "image_pull_secrets" in self.model_fields_set
        ):
            _dict["imagePullSecrets"] = None

        # set to None if tolerations (nullable) is None
        # and model_fields_set contains the field
        if self.tolerations is None and "tolerations" in self.model_fields_set:
            _dict["tolerations"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvancedItemizedDefaults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "annotations": (
                    AnnotationsDefaults.from_dict(obj["annotations"])
                    if obj.get("annotations") is not None
                    else None
                ),
                "labels": (
                    LabelsDefaults.from_dict(obj["labels"])
                    if obj.get("labels") is not None
                    else None
                ),
                "imagePullSecrets": (
                    ImagePullSecretsDefaults.from_dict(obj["imagePullSecrets"])
                    if obj.get("imagePullSecrets") is not None
                    else None
                ),
                "tolerations": (
                    TolerationsDefaults.from_dict(obj["tolerations"])
                    if obj.get("tolerations") is not None
                    else None
                ),
            }
        )
        return _obj
