# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.aggregated_resources_memory import AggregatedResourcesMemory
from runai.models.aggregated_resources_node_pool import AggregatedResourcesNodePool
from runai.models.deserved_resource import DeservedResource
from typing import Optional, Set
from typing_extensions import Self


class AggregatedResources(BaseModel):
    """
    Pydantic class model representing Sum of all resources assigned to the projects under this department per Node Pool.

    Parameters:
        ```python
        node_pool: AggregatedResourcesNodePool
        gpu: DeservedResource
        cpu: DeservedResource
        memory: AggregatedResourcesMemory
        ```
        node_pool: See model AggregatedResourcesNodePool for more information.
        gpu: See model DeservedResource for more information.
        cpu: See model DeservedResource for more information.
        memory: See model AggregatedResourcesMemory for more information.
    Example:
        ```python
        AggregatedResources(
            node_pool=runai.models.aggregated_resources_node_pool.AggregatedResources_nodePool(
                    id = '22',
                    name = 'default', ),
                        gpu=runai.models.deserved_resource.DeservedResource(
                    deserved = 1000, ),
                        cpu=runai.models.deserved_resource.DeservedResource(
                    deserved = 1000, ),
                        memory="example"
        )
        ```
    """  # noqa: E501

    node_pool: AggregatedResourcesNodePool = Field(alias="nodePool")
    gpu: Optional[DeservedResource] = None
    cpu: Optional[DeservedResource] = None
    memory: Optional[AggregatedResourcesMemory] = None
    __properties: ClassVar[List[str]] = ["nodePool", "gpu", "cpu", "memory"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AggregatedResources from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of node_pool
        if self.node_pool:
            _dict["nodePool"] = self.node_pool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu
        if self.gpu:
            _dict["gpu"] = self.gpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu
        if self.cpu:
            _dict["cpu"] = self.cpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory
        if self.memory:
            _dict["memory"] = self.memory.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AggregatedResources from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "nodePool": (
                    AggregatedResourcesNodePool.from_dict(obj["nodePool"])
                    if obj.get("nodePool") is not None
                    else None
                ),
                "gpu": (
                    DeservedResource.from_dict(obj["gpu"])
                    if obj.get("gpu") is not None
                    else None
                ),
                "cpu": (
                    DeservedResource.from_dict(obj["cpu"])
                    if obj.get("cpu") is not None
                    else None
                ),
                "memory": (
                    AggregatedResourcesMemory.from_dict(obj["memory"])
                    if obj.get("memory") is not None
                    else None
                ),
            }
        )
        return _obj
