# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.asset_kind import AssetKind
from typing import Optional, Set
from typing_extensions import Self


class AssetReadOnlyFields(BaseModel):
    """
    Pydantic class model representing AssetReadOnlyFields.

    Parameters:
        ```python
        id: str
        kind: AssetKind
        tenant_id: Optional[int]
        created_by: str
        created_at: datetime
        updated_by: str
        updated_at: datetime
        deleted_at: datetime
        deleted_by: str
        project_name: Optional[str]
        update_count: int
        ```
        id: Unique identifier of the asset.
        kind: See model AssetKind for more information.
        tenant_id: The id of the tenant.
        created_by: The user who created the asset.
        created_at: The time at which the asset were created
        updated_by: The user who updated the asset.
        updated_at: The time at which the asset has been updated
        deleted_at: Deletion time of the asset (relevant for assets that sync to the cluster)
        deleted_by: The user who deleted the asset
        project_name: The name of the project that the asset is associated with, for project scoped assets.
        update_count: the value of an update counter of a data in the system.
    Example:
        ```python
        AssetReadOnlyFields(
            id='0',
                        kind='compute',
                        tenant_id=56,
                        created_by='0',
                        created_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        updated_by='0',
                        updated_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        deleted_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        deleted_by='0',
                        project_name='0',
                        update_count=12345
        )
        ```
    """  # noqa: E501

    id: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="Unique identifier of the asset."
    )
    kind: AssetKind
    tenant_id: Optional[StrictInt] = Field(
        default=None, description="The id of the tenant.", alias="tenantId"
    )
    created_by: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="The user who created the asset.", alias="createdBy"
    )
    created_at: datetime = Field(
        description="The time at which the asset were created", alias="createdAt"
    )
    updated_by: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="The user who updated the asset.", alias="updatedBy"
    )
    updated_at: datetime = Field(
        description="The time at which the asset has been updated", alias="updatedAt"
    )
    deleted_at: Optional[datetime] = Field(
        default=None,
        description="Deletion time of the asset (relevant for assets that sync to the cluster)",
        alias="deletedAt",
    )
    deleted_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None, description="The user who deleted the asset", alias="deletedBy"
    )
    project_name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="The name of the project that the asset is associated with, for project scoped assets.",
        alias="projectName",
    )
    update_count: Optional[StrictInt] = Field(
        default=None,
        description="the value of an update counter of a data in the system.",
        alias="updateCount",
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "kind",
        "tenantId",
        "createdBy",
        "createdAt",
        "updatedBy",
        "updatedAt",
        "deletedAt",
        "deletedBy",
        "projectName",
        "updateCount",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssetReadOnlyFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tenant_id (nullable) is None
        # and model_fields_set contains the field
        if self.tenant_id is None and "tenant_id" in self.model_fields_set:
            _dict["tenantId"] = None

        # set to None if project_name (nullable) is None
        # and model_fields_set contains the field
        if self.project_name is None and "project_name" in self.model_fields_set:
            _dict["projectName"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssetReadOnlyFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "kind": obj.get("kind"),
                "tenantId": obj.get("tenantId"),
                "createdBy": obj.get("createdBy"),
                "createdAt": obj.get("createdAt"),
                "updatedBy": obj.get("updatedBy"),
                "updatedAt": obj.get("updatedAt"),
                "deletedAt": obj.get("deletedAt"),
                "deletedBy": obj.get("deletedBy"),
                "projectName": obj.get("projectName"),
                "updateCount": obj.get("updateCount"),
            }
        )
        return _obj
