# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class Capability(str, Enum):
    """
    Capability

    Allowed enum values:

    AUDIT_CONTROL = 'AUDIT_CONTROL'

    AUDIT_READ = 'AUDIT_READ'

    AUDIT_WRITE = 'AUDIT_WRITE'

    BLOCK_SUSPEND = 'BLOCK_SUSPEND'

    CHOWN = 'CHOWN'

    DAC_OVERRIDE = 'DAC_OVERRIDE'

    DAC_READ_SEARCH = 'DAC_READ_SEARCH'

    FOWNER = 'FOWNER'

    FSETID = 'FSETID'

    IPC_LOCK = 'IPC_LOCK'

    IPC_OWNER = 'IPC_OWNER'

    KILL = 'KILL'

    LEASE = 'LEASE'

    LINUX_IMMUTABLE = 'LINUX_IMMUTABLE'

    MAC_ADMIN = 'MAC_ADMIN'

    MAC_OVERRIDE = 'MAC_OVERRIDE'

    MKNOD = 'MKNOD'

    NET_ADMIN = 'NET_ADMIN'

    NET_BIND_SERVICE = 'NET_BIND_SERVICE'

    NET_BROADCAST = 'NET_BROADCAST'

    NET_RAW = 'NET_RAW'

    SETGID = 'SETGID'

    SETFCAP = 'SETFCAP'

    SETPCAP = 'SETPCAP'

    SETUID = 'SETUID'

    SYS_ADMIN = 'SYS_ADMIN'

    SYS_BOOT = 'SYS_BOOT'

    SYS_CHROOT = 'SYS_CHROOT'

    SYS_MODULE = 'SYS_MODULE'

    SYS_NICE = 'SYS_NICE'

    SYS_PACCT = 'SYS_PACCT'

    SYS_PTRACE = 'SYS_PTRACE'

    SYS_RAWIO = 'SYS_RAWIO'

    SYS_RESOURCE = 'SYS_RESOURCE'

    SYS_TIME = 'SYS_TIME'

    SYS_TTY_CONFIG = 'SYS_TTY_CONFIG'

    SYSLOG = 'SYSLOG'

    WAKE_ALARM = 'WAKE_ALARM'


    Example:
        ```python
        Capability.AUDIT_CONTROL
        Capability.AUDIT_READ
        Capability.AUDIT_WRITE
        Capability.BLOCK_SUSPEND
        Capability.CHOWN
        Capability.DAC_OVERRIDE
        Capability.DAC_READ_SEARCH
        Capability.FOWNER
        Capability.FSETID
        Capability.IPC_LOCK
        Capability.IPC_OWNER
        Capability.KILL
        Capability.LEASE
        Capability.LINUX_IMMUTABLE
        Capability.MAC_ADMIN
        Capability.MAC_OVERRIDE
        Capability.MKNOD
        Capability.NET_ADMIN
        Capability.NET_BIND_SERVICE
        Capability.NET_BROADCAST
        Capability.NET_RAW
        Capability.SETGID
        Capability.SETFCAP
        Capability.SETPCAP
        Capability.SETUID
        Capability.SYS_ADMIN
        Capability.SYS_BOOT
        Capability.SYS_CHROOT
        Capability.SYS_MODULE
        Capability.SYS_NICE
        Capability.SYS_PACCT
        Capability.SYS_PTRACE
        Capability.SYS_RAWIO
        Capability.SYS_RESOURCE
        Capability.SYS_TIME
        Capability.SYS_TTY_CONFIG
        Capability.SYSLOG
        Capability.WAKE_ALARM
        ```
    """

    AUDIT_CONTROL = "AUDIT_CONTROL"
    AUDIT_READ = "AUDIT_READ"
    AUDIT_WRITE = "AUDIT_WRITE"
    BLOCK_SUSPEND = "BLOCK_SUSPEND"
    CHOWN = "CHOWN"
    DAC_OVERRIDE = "DAC_OVERRIDE"
    DAC_READ_SEARCH = "DAC_READ_SEARCH"
    FOWNER = "FOWNER"
    FSETID = "FSETID"
    IPC_LOCK = "IPC_LOCK"
    IPC_OWNER = "IPC_OWNER"
    KILL = "KILL"
    LEASE = "LEASE"
    LINUX_IMMUTABLE = "LINUX_IMMUTABLE"
    MAC_ADMIN = "MAC_ADMIN"
    MAC_OVERRIDE = "MAC_OVERRIDE"
    MKNOD = "MKNOD"
    NET_ADMIN = "NET_ADMIN"
    NET_BIND_SERVICE = "NET_BIND_SERVICE"
    NET_BROADCAST = "NET_BROADCAST"
    NET_RAW = "NET_RAW"
    SETGID = "SETGID"
    SETFCAP = "SETFCAP"
    SETPCAP = "SETPCAP"
    SETUID = "SETUID"
    SYS_ADMIN = "SYS_ADMIN"
    SYS_BOOT = "SYS_BOOT"
    SYS_CHROOT = "SYS_CHROOT"
    SYS_MODULE = "SYS_MODULE"
    SYS_NICE = "SYS_NICE"
    SYS_PACCT = "SYS_PACCT"
    SYS_PTRACE = "SYS_PTRACE"
    SYS_RAWIO = "SYS_RAWIO"
    SYS_RESOURCE = "SYS_RESOURCE"
    SYS_TIME = "SYS_TIME"
    SYS_TTY_CONFIG = "SYS_TTY_CONFIG"
    SYSLOG = "SYSLOG"
    WAKE_ALARM = "WAKE_ALARM"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Capability from a JSON string"""
        return cls(json.loads(json_str))
