# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.pvc_access_modes import PvcAccessModes
from runai.models.pvc_added_attr_value import PvcAddedAttrValue
from runai.models.pvc_volume_mode import PvcVolumeMode
from typing import Optional, Set
from typing_extensions import Self


class ClaimInfo(BaseModel):
    """
    Pydantic class model representing Claim information for the newly created PVC. The information should not be provided when attempting to use existing PVC..

    Parameters:
        ```python
        size: Optional[str]
        storage_class: Optional[str]
        access_modes: Optional[PvcAccessModes]
        volume_mode: Optional[PvcVolumeMode]
        added_attr_values: List[PvcAddedAttrValue]
        ```
        size: Requested size for the PVC. Mandatory when existingPvc is false. Recommended sizes: TB/GB/MB/TIB/GIB/MIB
        storage_class: Storage class name to associate with the PVC. This parameter may be omitted if there is a single storage class in the system, or you are using the default storage class. For more information, see [Storage class](https://kubernetes.io/docs/concepts/storage/storage-classes).
        access_modes: See model PvcAccessModes for more information.
        volume_mode: See model PvcVolumeMode for more information.
        added_attr_values: an optional array of key-values pairs that are written as annotations on the created PVC. the allowed attributes are determined according to the storage class configuration (see k8s-objects-tracker for further info).
    Example:
        ```python
        ClaimInfo(
            size='1G',
                        storage_class='my-storage-class',
                        access_modes=runai.models.pvc_access_modes.PvcAccessModes(
                    read_write_once = True,
                    read_only_many = True,
                    read_write_many = True, ),
                        volume_mode='Filesystem',
                        added_attr_values=[
                    runai.models.pvc_added_attr_value.PvcAddedAttrValue(
                        key = 'dnsname',
                        value = 'my.dns.com', )
                    ]
        )
        ```
    """  # noqa: E501

    size: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None,
        description="Requested size for the PVC. Mandatory when existingPvc is false. Recommended sizes: TB/GB/MB/TIB/GIB/MIB",
    )
    storage_class: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Storage class name to associate with the PVC. This parameter may be omitted if there is a single storage class in the system, or you are using the default storage class. For more information, see [Storage class](https://kubernetes.io/docs/concepts/storage/storage-classes).",
        alias="storageClass",
    )
    access_modes: Optional[PvcAccessModes] = Field(default=None, alias="accessModes")
    volume_mode: Optional[PvcVolumeMode] = Field(default=None, alias="volumeMode")
    added_attr_values: Optional[List[PvcAddedAttrValue]] = Field(
        default=None,
        description="an optional array of key-values pairs that are written as annotations on the created PVC. the allowed attributes are determined according to the storage class configuration (see k8s-objects-tracker for further info).",
        alias="addedAttrValues",
    )
    __properties: ClassVar[List[str]] = [
        "size",
        "storageClass",
        "accessModes",
        "volumeMode",
        "addedAttrValues",
    ]

    @field_validator("size")
    def size_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([+-]?[0-9.]+)([eEinumkKMGTP]*[-+]?[0-9]*)$", value):
            raise ValueError(
                r"must validate the regular expression /^([+-]?[0-9.]+)([eEinumkKMGTP]*[-+]?[0-9]*)$/"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClaimInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of access_modes
        if self.access_modes:
            _dict["accessModes"] = self.access_modes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in added_attr_values (list)
        _items = []
        if self.added_attr_values:
            for _item_added_attr_values in self.added_attr_values:
                if _item_added_attr_values:
                    _items.append(_item_added_attr_values.to_dict())
            _dict["addedAttrValues"] = _items
        # set to None if size (nullable) is None
        # and model_fields_set contains the field
        if self.size is None and "size" in self.model_fields_set:
            _dict["size"] = None

        # set to None if storage_class (nullable) is None
        # and model_fields_set contains the field
        if self.storage_class is None and "storage_class" in self.model_fields_set:
            _dict["storageClass"] = None

        # set to None if access_modes (nullable) is None
        # and model_fields_set contains the field
        if self.access_modes is None and "access_modes" in self.model_fields_set:
            _dict["accessModes"] = None

        # set to None if volume_mode (nullable) is None
        # and model_fields_set contains the field
        if self.volume_mode is None and "volume_mode" in self.model_fields_set:
            _dict["volumeMode"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClaimInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "size": obj.get("size"),
                "storageClass": obj.get("storageClass"),
                "accessModes": (
                    PvcAccessModes.from_dict(obj["accessModes"])
                    if obj.get("accessModes") is not None
                    else None
                ),
                "volumeMode": obj.get("volumeMode"),
                "addedAttrValues": (
                    [
                        PvcAddedAttrValue.from_dict(_item)
                        for _item in obj["addedAttrValues"]
                    ]
                    if obj.get("addedAttrValues") is not None
                    else None
                ),
            }
        )
        return _obj
