# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.pvc_access_modes_rules import PvcAccessModesRules
from runai.models.string_rules import StringRules
from typing import Optional, Set
from typing_extensions import Self


class ClaimInfoRules(BaseModel):
    """
    Pydantic class model representing ClaimInfoRules.

    Parameters:
        ```python
        size: Optional[StringRules]
        storage_class: Optional[StringRules]
        access_modes: Optional[PvcAccessModesRules]
        ```
        size: See model StringRules for more information.
        storage_class: See model StringRules for more information.
        access_modes: See model PvcAccessModesRules for more information.
    Example:
        ```python
        ClaimInfoRules(
            size=runai.models.string_rules.StringRules(),
                        storage_class=runai.models.string_rules.StringRules(),
                        access_modes=runai.models.pvc_access_modes_rules.PvcAccessModesRules(
                    read_write_once = runai.models.boolean_rules.BooleanRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        required = True,
                        can_edit = True, ),
                    read_only_many = runai.models.boolean_rules.BooleanRules(
                        required = True,
                        can_edit = True, ),
                    read_write_many = , )
        )
        ```
    """  # noqa: E501

    size: Optional[StringRules] = None
    storage_class: Optional[StringRules] = Field(default=None, alias="storageClass")
    access_modes: Optional[PvcAccessModesRules] = Field(
        default=None, alias="accessModes"
    )
    __properties: ClassVar[List[str]] = ["size", "storageClass", "accessModes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClaimInfoRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of size
        if self.size:
            _dict["size"] = self.size.to_dict()
        # override the default output from pydantic by calling `to_dict()` of storage_class
        if self.storage_class:
            _dict["storageClass"] = self.storage_class.to_dict()
        # override the default output from pydantic by calling `to_dict()` of access_modes
        if self.access_modes:
            _dict["accessModes"] = self.access_modes.to_dict()
        # set to None if size (nullable) is None
        # and model_fields_set contains the field
        if self.size is None and "size" in self.model_fields_set:
            _dict["size"] = None

        # set to None if storage_class (nullable) is None
        # and model_fields_set contains the field
        if self.storage_class is None and "storage_class" in self.model_fields_set:
            _dict["storageClass"] = None

        # set to None if access_modes (nullable) is None
        # and model_fields_set contains the field
        if self.access_modes is None and "access_modes" in self.model_fields_set:
            _dict["accessModes"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClaimInfoRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "size": (
                    StringRules.from_dict(obj["size"])
                    if obj.get("size") is not None
                    else None
                ),
                "storageClass": (
                    StringRules.from_dict(obj["storageClass"])
                    if obj.get("storageClass") is not None
                    else None
                ),
                "accessModes": (
                    PvcAccessModesRules.from_dict(obj["accessModes"])
                    if obj.get("accessModes") is not None
                    else None
                ),
            }
        )
        return _obj
