# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.cluster_dependencies_status import ClusterDependenciesStatus
from runai.models.cluster_reported_config import ClusterReportedConfig
from runai.models.cluster_reported_status_conditions_inner import (
    ClusterReportedStatusConditionsInner,
)
from runai.models.cluster_reported_status_operands_value import (
    ClusterReportedStatusOperandsValue,
)
from runai.models.cluster_reported_status_platform import ClusterReportedStatusPlatform
from typing import Optional, Set
from typing_extensions import Self


class ClusterDisplayedStatus(BaseModel):
    """
    Pydantic class model representing The cluster's displayed status..

    Parameters:
        ```python
        conditions: List[ClusterReportedStatusConditionsInner]
        operands: Dict[str, ClusterReportedStatusOperandsValue]
        platform: Optional[ClusterReportedStatusPlatform]
        config: Optional[ClusterReportedConfig]
        dependencies: ClusterDependenciesStatus
        state: str
        ```
        conditions: See model List[ClusterReportedStatusConditionsInner] for more information.
        operands: OperandStatuses specifies the status of the managed operands
        platform: See model ClusterReportedStatusPlatform for more information.
        config: See model ClusterReportedConfig for more information.
        dependencies: See model ClusterDependenciesStatus for more information.
        state: The cluster&#39;s state.
    Example:
        ```python
        ClusterDisplayedStatus(
            conditions=[
                    runai.models.cluster_reported_status_conditions_inner.ClusterReportedStatus_conditions_inner(
                        last_transition_time = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        message = '',
                        observed_generation = 0,
                        reason = 'AbUUGjjNSwg1_bs:ZayIMrKdgNvb7gvxmPb:GcsM72ate2RA9:q4w2l5eH5XxEz06awo0',
                        status = 'True',
                        type = '', )
                    ],
                        operands={
                    'key' : runai.models.cluster_reported_status_operands_value.ClusterReportedStatus_operands_value(
                        last_transition_time = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        ready = True,
                        reasons = [
                            ''
                            ],
                        unready_threshold_crossed = True, )
                    },
                        platform=runai.models.cluster_reported_status_platform.ClusterReportedStatus_platform(
                    type = 'vanilla',
                    kube_version = '', ),
                        config=runai.models.cluster_reported_config.ClusterReportedConfig(
                    workload_ownership_protection = False,
                    subdomain_enabled = False, ),
                        dependencies=runai.models.cluster_dependencies_status.ClusterDependenciesStatus(
                    required = {
                        'key' : runai.models.cluster_dependency_status.ClusterDependencyStatus(
                            available = True,
                            reason = '',
                            components = {
                                'key' : runai.models.cluster_dependency_status.ClusterDependencyStatus(
                                    available = True,
                                    reason = '', )
                                }, )
                        },
                    optional = {
                        'key' :
                        }, ),
                        state='WaitingToConnect'
        )
        ```
    """  # noqa: E501

    conditions: Optional[List[ClusterReportedStatusConditionsInner]] = None
    operands: Optional[Dict[str, ClusterReportedStatusOperandsValue]] = Field(
        default=None,
        description="OperandStatuses specifies the status of the managed operands",
    )
    platform: Optional[ClusterReportedStatusPlatform] = None
    config: Optional[ClusterReportedConfig] = None
    dependencies: Optional[ClusterDependenciesStatus] = None
    state: Optional[StrictStr] = Field(default=None, description="The cluster's state.")
    __properties: ClassVar[List[str]] = [
        "conditions",
        "operands",
        "platform",
        "config",
        "dependencies",
        "state",
    ]

    @field_validator("state")
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "WaitingToConnect",
                "Connected",
                "Disconnected",
                "MissingPrerequisites",
                "ServiceIssues",
                "Unknown",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('WaitingToConnect', 'Connected', 'Disconnected', 'MissingPrerequisites', 'ServiceIssues', 'Unknown')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterDisplayedStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict["conditions"] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in operands (dict)
        _field_dict = {}
        if self.operands:
            for _key_operands in self.operands:
                if self.operands[_key_operands]:
                    _field_dict[_key_operands] = self.operands[_key_operands].to_dict()
            _dict["operands"] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict["platform"] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict["config"] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dependencies
        if self.dependencies:
            _dict["dependencies"] = self.dependencies.to_dict()
        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict["platform"] = None

        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict["config"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterDisplayedStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "conditions": (
                    [
                        ClusterReportedStatusConditionsInner.from_dict(_item)
                        for _item in obj["conditions"]
                    ]
                    if obj.get("conditions") is not None
                    else None
                ),
                "operands": (
                    dict(
                        (_k, ClusterReportedStatusOperandsValue.from_dict(_v))
                        for _k, _v in obj["operands"].items()
                    )
                    if obj.get("operands") is not None
                    else None
                ),
                "platform": (
                    ClusterReportedStatusPlatform.from_dict(obj["platform"])
                    if obj.get("platform") is not None
                    else None
                ),
                "config": (
                    ClusterReportedConfig.from_dict(obj["config"])
                    if obj.get("config") is not None
                    else None
                ),
                "dependencies": (
                    ClusterDependenciesStatus.from_dict(obj["dependencies"])
                    if obj.get("dependencies") is not None
                    else None
                ),
                "state": obj.get("state"),
            }
        )
        return _obj
