# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class ClusterPriority(BaseModel):
    """
    Pydantic class model representing ClusterPriority.

    Parameters:
        ```python
        id: str
        source: str
        name: str
        value: int
        created_at: datetime
        updated_at: datetime
        phase: str
        ```
        id: The unique identifier of the workload priority
        source: The source of the priority class. Indicates where the priority definition originated. Currently, the value is either Run:ai or empty.
        name: The name of the workload priority (e.g., low, medium, high)
        value: The scheduling value assigned to this priority
        created_at: The timestamp for when the priority was created
        updated_at: The timestamp for when the priority was updated
        phase: Current phase of the priority in the specified cluster
    Example:
        ```python
        ClusterPriority(
            id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        source='Run:ai',
                        name='medium',
                        value=50,
                        created_at='2022-01-01T03:49:52.531Z',
                        updated_at='2022-06-08T11:28:24.131Z',
                        phase='Ready'
        )
        ```
    """  # noqa: E501

    id: StrictStr = Field(description="The unique identifier of the workload priority")
    source: Optional[StrictStr] = Field(
        default=None,
        description="The source of the priority class. Indicates where the priority definition originated. Currently, the value is either Run:ai or empty.",
    )
    name: StrictStr = Field(
        description="The name of the workload priority (e.g., low, medium, high)"
    )
    value: Annotated[int, Field(strict=True, ge=0)] = Field(
        description="The scheduling value assigned to this priority"
    )
    created_at: Optional[datetime] = Field(
        default=None,
        description="The timestamp for when the priority was created",
        alias="createdAt",
    )
    updated_at: Optional[datetime] = Field(
        default=None,
        description="The timestamp for when the priority was updated",
        alias="updatedAt",
    )
    phase: Optional[StrictStr] = Field(
        default=None,
        description="Current phase of the priority in the specified cluster",
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "source",
        "name",
        "value",
        "createdAt",
        "updatedAt",
        "phase",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterPriority from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterPriority from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "source": obj.get("source"),
                "name": obj.get("name"),
                "value": obj.get("value"),
                "createdAt": obj.get("createdAt"),
                "updatedAt": obj.get("updatedAt"),
                "phase": obj.get("phase"),
            }
        )
        return _obj
