# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class ClusterReportedStatusOperandsValue(BaseModel):
    """
    Pydantic class model representing Status specifies the status of an operand. And operand manages resources, some of which are not immediately available and need their status monitored, such as Deployments, Daemonsets, Ingressess etc. Some resources are immediately available and should not be monitored once accepted by the cluster, such as Services, ConfigMaps, Secrets etc. If all resources of an operand are ready, a Status with Ready set to 'true' and a nil 'Reasons' slice should be returned, otherwise, a Status with 'Reasons' slice containig the reason why the Operand is not ready (Deployment pods are not ready for example.).

    Parameters:
        ```python
        last_transition_time: datetime
        ready: bool
        reasons: List[str]
        unready_threshold_crossed: bool
        ```
        last_transition_time: LastTransitionTime specifies the last time the operand readiness changed
        ready: Ready specifies if the operand is ready or not
        reasons: Reasons specifies the reasons why the operand is not ready
        unready_threshold_crossed: UnreadyThresholdCrossed specifies if the operand has been unready for longer than the threshold
    Example:
        ```python
        ClusterReportedStatusOperandsValue(
            last_transition_time=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        ready=True,
                        reasons=[
                    ''
                    ],
                        unready_threshold_crossed=True
        )
        ```
    """  # noqa: E501

    last_transition_time: Optional[datetime] = Field(
        default=None,
        description="LastTransitionTime specifies the last time the operand readiness changed",
        alias="lastTransitionTime",
    )
    ready: StrictBool = Field(
        description="Ready specifies if the operand is ready or not"
    )
    reasons: Optional[List[StrictStr]] = Field(
        default=None,
        description="Reasons specifies the reasons why the operand is not ready",
    )
    unready_threshold_crossed: Optional[StrictBool] = Field(
        default=None,
        description="UnreadyThresholdCrossed specifies if the operand has been unready for longer than the threshold",
        alias="unreadyThresholdCrossed",
    )
    __properties: ClassVar[List[str]] = [
        "lastTransitionTime",
        "ready",
        "reasons",
        "unreadyThresholdCrossed",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterReportedStatusOperandsValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterReportedStatusOperandsValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "lastTransitionTime": obj.get("lastTransitionTime"),
                "ready": obj.get("ready"),
                "reasons": obj.get("reasons"),
                "unreadyThresholdCrossed": obj.get("unreadyThresholdCrossed"),
            }
        )
        return _obj
