# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.annotation import Annotation
from runai.models.environment_variable import EnvironmentVariable
from runai.models.image_pull_secret import ImagePullSecret
from runai.models.label import Label
from runai.models.toleration import Toleration
from typing import Optional, Set
from typing_extensions import Self


class CommonItemizedFields(BaseModel):
    """
    Pydantic class model representing CommonItemizedFields.

    Parameters:
        ```python
        environment_variables: Optional[List[EnvironmentVariable]]
        annotations: Optional[List[Annotation]]
        labels: Optional[List[Label]]
        image_pull_secrets: Optional[List[ImagePullSecret]]
        tolerations: Optional[List[Toleration]]
        ```
        environment_variables: Set of environment variables to populate into the container running the workload.
        annotations: Set of annotations to populate into the container running the workload.
        labels: Set of labels to populate into the container running the workload.
        image_pull_secrets: A list of references to Kubernetes secrets in the same namespace used for pulling container images.
        tolerations: Set of tolerations to apply to the workload.
    Example:
        ```python
        CommonItemizedFields(
            environment_variables=[
                    runai.models.environment_variable.EnvironmentVariable(
                        name = 'HOME',
                        value = '/home/my-folder',
                        secret = runai.models.environment_variable_secret.EnvironmentVariableSecret(
                            name = 'postgress_secret',
                            key = 'POSTGRES_PASSWORD', ),
                        config_map = runai.models.environment_variable_config_map.EnvironmentVariableConfigMap(
                            name = 'my-config-map',
                            key = 'MY_POSTGRES_SCHEMA', ),
                        pod_field_ref = runai.models.environment_variable_pod_field_reference.EnvironmentVariablePodFieldReference(
                            path = 'metadata.name', ),
                        exclude = False,
                        description = 'Home directory of the user.', )
                    ],
                        annotations=[
                    runai.models.annotation.Annotation(
                        name = 'billing',
                        value = 'my-billing-unit',
                        exclude = False, )
                    ],
                        labels=[
                    runai.models.label.Label(
                        name = 'stage',
                        value = 'initial-research',
                        exclude = False, )
                    ],
                        image_pull_secrets=[
                    runai.models.image_pull_secret.ImagePullSecret(
                        name = '',
                        user_credential = True,
                        exclude = False, )
                    ],
                        tolerations=[
                    runai.models.toleration.Toleration(
                        name = '0',
                        operator = 'Equal',
                        key = '',
                        value = '',
                        effect = 'NoSchedule',
                        seconds = 1,
                        exclude = False, )
                    ]
        )
        ```
    """  # noqa: E501

    environment_variables: Optional[List[Optional[EnvironmentVariable]]] = Field(
        default=None,
        description="Set of environment variables to populate into the container running the workload.",
        alias="environmentVariables",
    )
    annotations: Optional[List[Optional[Annotation]]] = Field(
        default=None,
        description="Set of annotations to populate into the container running the workload.",
    )
    labels: Optional[List[Optional[Label]]] = Field(
        default=None,
        description="Set of labels to populate into the container running the workload.",
    )
    image_pull_secrets: Optional[List[Optional[ImagePullSecret]]] = Field(
        default=None,
        description="A list of references to Kubernetes secrets in the same namespace used for pulling container images.",
        alias="imagePullSecrets",
    )
    tolerations: Optional[List[Optional[Toleration]]] = Field(
        default=None, description="Set of tolerations to apply to the workload."
    )
    __properties: ClassVar[List[str]] = [
        "environmentVariables",
        "annotations",
        "labels",
        "imagePullSecrets",
        "tolerations",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommonItemizedFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in environment_variables (list)
        _items = []
        if self.environment_variables:
            for _item_environment_variables in self.environment_variables:
                if _item_environment_variables:
                    _items.append(_item_environment_variables.to_dict())
            _dict["environmentVariables"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in annotations (list)
        _items = []
        if self.annotations:
            for _item_annotations in self.annotations:
                if _item_annotations:
                    _items.append(_item_annotations.to_dict())
            _dict["annotations"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict["labels"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in image_pull_secrets (list)
        _items = []
        if self.image_pull_secrets:
            for _item_image_pull_secrets in self.image_pull_secrets:
                if _item_image_pull_secrets:
                    _items.append(_item_image_pull_secrets.to_dict())
            _dict["imagePullSecrets"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tolerations (list)
        _items = []
        if self.tolerations:
            for _item_tolerations in self.tolerations:
                if _item_tolerations:
                    _items.append(_item_tolerations.to_dict())
            _dict["tolerations"] = _items
        # set to None if environment_variables (nullable) is None
        # and model_fields_set contains the field
        if (
            self.environment_variables is None
            and "environment_variables" in self.model_fields_set
        ):
            _dict["environmentVariables"] = None

        # set to None if annotations (nullable) is None
        # and model_fields_set contains the field
        if self.annotations is None and "annotations" in self.model_fields_set:
            _dict["annotations"] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict["labels"] = None

        # set to None if image_pull_secrets (nullable) is None
        # and model_fields_set contains the field
        if (
            self.image_pull_secrets is None
            and "image_pull_secrets" in self.model_fields_set
        ):
            _dict["imagePullSecrets"] = None

        # set to None if tolerations (nullable) is None
        # and model_fields_set contains the field
        if self.tolerations is None and "tolerations" in self.model_fields_set:
            _dict["tolerations"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommonItemizedFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "environmentVariables": (
                    [
                        EnvironmentVariable.from_dict(_item)
                        for _item in obj["environmentVariables"]
                    ]
                    if obj.get("environmentVariables") is not None
                    else None
                ),
                "annotations": (
                    [Annotation.from_dict(_item) for _item in obj["annotations"]]
                    if obj.get("annotations") is not None
                    else None
                ),
                "labels": (
                    [Label.from_dict(_item) for _item in obj["labels"]]
                    if obj.get("labels") is not None
                    else None
                ),
                "imagePullSecrets": (
                    [
                        ImagePullSecret.from_dict(_item)
                        for _item in obj["imagePullSecrets"]
                    ]
                    if obj.get("imagePullSecrets") is not None
                    else None
                ),
                "tolerations": (
                    [Toleration.from_dict(_item) for _item in obj["tolerations"]]
                    if obj.get("tolerations") is not None
                    else None
                ),
            }
        )
        return _obj
