# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.boolean_rules import BooleanRules
from runai.models.extended_resources_rules import ExtendedResourcesRules
from runai.models.gpu_request_rules import GpuRequestRules
from runai.models.integer_rules import IntegerRules
from runai.models.mig_profile_rules import MigProfileRules
from runai.models.number_rules import NumberRules
from runai.models.quantity_rules import QuantityRules
from typing import Optional, Set
from typing_extensions import Self


class ComputeFieldsRules(BaseModel):
    """
    Pydantic class model representing ComputeFieldsRules.

    Parameters:
        ```python
        cpu_core_request: Optional[NumberRules]
        cpu_core_limit: Optional[NumberRules]
        cpu_memory_request: Optional[QuantityRules]
        cpu_memory_limit: Optional[QuantityRules]
        large_shm_request: Optional[BooleanRules]
        gpu_request_type: Optional[GpuRequestRules]
        mig_profile: Optional[MigProfileRules]
        gpu_devices_request: Optional[IntegerRules]
        gpu_portion_request: Optional[NumberRules]
        gpu_portion_limit: Optional[NumberRules]
        gpu_memory_request: Optional[QuantityRules]
        gpu_memory_limit: Optional[QuantityRules]
        extended_resources: Optional[ExtendedResourcesRules]
        ```
        cpu_core_request: See model NumberRules for more information.
        cpu_core_limit: See model NumberRules for more information.
        cpu_memory_request: See model QuantityRules for more information.
        cpu_memory_limit: See model QuantityRules for more information.
        large_shm_request: See model BooleanRules for more information.
        gpu_request_type: See model GpuRequestRules for more information.
        mig_profile: See model MigProfileRules for more information.
        gpu_devices_request: See model IntegerRules for more information.
        gpu_portion_request: See model NumberRules for more information.
        gpu_portion_limit: See model NumberRules for more information.
        gpu_memory_request: See model QuantityRules for more information.
        gpu_memory_limit: See model QuantityRules for more information.
        extended_resources: See model ExtendedResourcesRules for more information.
    Example:
        ```python
        ComputeFieldsRules(
            cpu_core_request=runai.models.number_rules.NumberRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 1.337,
                    max = 1.337,
                    step = 1.337,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        cpu_core_limit=runai.models.number_rules.NumberRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 1.337,
                    max = 1.337,
                    step = 1.337,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        cpu_memory_request=runai.models.quantity_rules.QuantityRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = '-0..1.73182.66.03300982804.9021169267472mmMGGmuikTPEPmTGiGkePiGemGmmnmeiniPPkTPnEePKmnuuEinuiGEEuiGuMETMPTPmeeKPenkETmEkMikEe-521919116647837856387556598',
                    max = '-0..1.73182.66.03300982804.9021169267472mmMGGmuikTPEPmTGiGkePiGemGmmnmeiniPPkTPnEePKmnuuEinuiGEEuiGuMETMPTPmeeKPenkETmEkMikEe-521919116647837856387556598',
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        cpu_memory_limit=runai.models.quantity_rules.QuantityRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = '-0..1.73182.66.03300982804.9021169267472mmMGGmuikTPEPmTGiGkePiGemGmmnmeiniPPkTPnEePKmnuuEinuiGEEuiGuMETMPTPmeeKPenkETmEkMikEe-521919116647837856387556598',
                    max = '-0..1.73182.66.03300982804.9021169267472mmMGGmuikTPEPmTGiGkePiGemGmmnmeiniPPkTPnEePKmnuuEinuiGEEuiGuMETMPTPmeeKPenkETmEkMikEe-521919116647837856387556598',
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        large_shm_request=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, ),
                        gpu_request_type=runai.models.gpu_request_rules.GpuRequestRules(),
                        mig_profile=runai.models.mig_profile_rules.MigProfileRules(),
                        gpu_devices_request=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        gpu_portion_request=runai.models.number_rules.NumberRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 1.337,
                    max = 1.337,
                    step = 1.337,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        gpu_portion_limit=runai.models.number_rules.NumberRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 1.337,
                    max = 1.337,
                    step = 1.337,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        gpu_memory_request=runai.models.quantity_rules.QuantityRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = '-0..1.73182.66.03300982804.9021169267472mmMGGmuikTPEPmTGiGkePiGemGmmnmeiniPPkTPnEePKmnuuEinuiGEEuiGuMETMPTPmeeKPenkETmEkMikEe-521919116647837856387556598',
                    max = '-0..1.73182.66.03300982804.9021169267472mmMGGmuikTPEPmTGiGkePiGemGmmnmeiniPPkTPnEePKmnuuEinuiGEEuiGuMETMPTPmeeKPenkETmEkMikEe-521919116647837856387556598',
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        gpu_memory_limit=runai.models.quantity_rules.QuantityRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = '-0..1.73182.66.03300982804.9021169267472mmMGGmuikTPEPmTGiGkePiGemGmmnmeiniPPkTPnEePKmnuuEinuiGEEuiGuMETMPTPmeeKPenkETmEkMikEe-521919116647837856387556598',
                    max = '-0..1.73182.66.03300982804.9021169267472mmMGGmuikTPEPmTGiGkePiGemGmmnmeiniPPkTPnEePKmnuuEinuiGEEuiGuMETMPTPmeeKPenkETmEkMikEe-521919116647837856387556598',
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        extended_resources=runai.models.extended_resources_rules.ExtendedResourcesRules(
                    attributes = runai.models.extended_resource_rules.ExtendedResourceRules(
                        quantity = runai.models.string_rules.StringRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), )
        )
        ```
    """  # noqa: E501

    cpu_core_request: Optional[NumberRules] = Field(
        default=None, alias="cpuCoreRequest"
    )
    cpu_core_limit: Optional[NumberRules] = Field(default=None, alias="cpuCoreLimit")
    cpu_memory_request: Optional[QuantityRules] = Field(
        default=None, alias="cpuMemoryRequest"
    )
    cpu_memory_limit: Optional[QuantityRules] = Field(
        default=None, alias="cpuMemoryLimit"
    )
    large_shm_request: Optional[BooleanRules] = Field(
        default=None, alias="largeShmRequest"
    )
    gpu_request_type: Optional[GpuRequestRules] = Field(
        default=None, alias="gpuRequestType"
    )
    mig_profile: Optional[MigProfileRules] = Field(default=None, alias="migProfile")
    gpu_devices_request: Optional[IntegerRules] = Field(
        default=None, alias="gpuDevicesRequest"
    )
    gpu_portion_request: Optional[NumberRules] = Field(
        default=None, alias="gpuPortionRequest"
    )
    gpu_portion_limit: Optional[NumberRules] = Field(
        default=None, alias="gpuPortionLimit"
    )
    gpu_memory_request: Optional[QuantityRules] = Field(
        default=None, alias="gpuMemoryRequest"
    )
    gpu_memory_limit: Optional[QuantityRules] = Field(
        default=None, alias="gpuMemoryLimit"
    )
    extended_resources: Optional[ExtendedResourcesRules] = Field(
        default=None, alias="extendedResources"
    )
    __properties: ClassVar[List[str]] = [
        "cpuCoreRequest",
        "cpuCoreLimit",
        "cpuMemoryRequest",
        "cpuMemoryLimit",
        "largeShmRequest",
        "gpuRequestType",
        "migProfile",
        "gpuDevicesRequest",
        "gpuPortionRequest",
        "gpuPortionLimit",
        "gpuMemoryRequest",
        "gpuMemoryLimit",
        "extendedResources",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ComputeFieldsRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cpu_core_request
        if self.cpu_core_request:
            _dict["cpuCoreRequest"] = self.cpu_core_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu_core_limit
        if self.cpu_core_limit:
            _dict["cpuCoreLimit"] = self.cpu_core_limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu_memory_request
        if self.cpu_memory_request:
            _dict["cpuMemoryRequest"] = self.cpu_memory_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu_memory_limit
        if self.cpu_memory_limit:
            _dict["cpuMemoryLimit"] = self.cpu_memory_limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of large_shm_request
        if self.large_shm_request:
            _dict["largeShmRequest"] = self.large_shm_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_request_type
        if self.gpu_request_type:
            _dict["gpuRequestType"] = self.gpu_request_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mig_profile
        if self.mig_profile:
            _dict["migProfile"] = self.mig_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_devices_request
        if self.gpu_devices_request:
            _dict["gpuDevicesRequest"] = self.gpu_devices_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_portion_request
        if self.gpu_portion_request:
            _dict["gpuPortionRequest"] = self.gpu_portion_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_portion_limit
        if self.gpu_portion_limit:
            _dict["gpuPortionLimit"] = self.gpu_portion_limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_memory_request
        if self.gpu_memory_request:
            _dict["gpuMemoryRequest"] = self.gpu_memory_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_memory_limit
        if self.gpu_memory_limit:
            _dict["gpuMemoryLimit"] = self.gpu_memory_limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extended_resources
        if self.extended_resources:
            _dict["extendedResources"] = self.extended_resources.to_dict()
        # set to None if cpu_core_request (nullable) is None
        # and model_fields_set contains the field
        if (
            self.cpu_core_request is None
            and "cpu_core_request" in self.model_fields_set
        ):
            _dict["cpuCoreRequest"] = None

        # set to None if cpu_core_limit (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_core_limit is None and "cpu_core_limit" in self.model_fields_set:
            _dict["cpuCoreLimit"] = None

        # set to None if cpu_memory_request (nullable) is None
        # and model_fields_set contains the field
        if (
            self.cpu_memory_request is None
            and "cpu_memory_request" in self.model_fields_set
        ):
            _dict["cpuMemoryRequest"] = None

        # set to None if cpu_memory_limit (nullable) is None
        # and model_fields_set contains the field
        if (
            self.cpu_memory_limit is None
            and "cpu_memory_limit" in self.model_fields_set
        ):
            _dict["cpuMemoryLimit"] = None

        # set to None if large_shm_request (nullable) is None
        # and model_fields_set contains the field
        if (
            self.large_shm_request is None
            and "large_shm_request" in self.model_fields_set
        ):
            _dict["largeShmRequest"] = None

        # set to None if gpu_request_type (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_request_type is None
            and "gpu_request_type" in self.model_fields_set
        ):
            _dict["gpuRequestType"] = None

        # set to None if mig_profile (nullable) is None
        # and model_fields_set contains the field
        if self.mig_profile is None and "mig_profile" in self.model_fields_set:
            _dict["migProfile"] = None

        # set to None if gpu_devices_request (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_devices_request is None
            and "gpu_devices_request" in self.model_fields_set
        ):
            _dict["gpuDevicesRequest"] = None

        # set to None if gpu_portion_request (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_portion_request is None
            and "gpu_portion_request" in self.model_fields_set
        ):
            _dict["gpuPortionRequest"] = None

        # set to None if gpu_portion_limit (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_portion_limit is None
            and "gpu_portion_limit" in self.model_fields_set
        ):
            _dict["gpuPortionLimit"] = None

        # set to None if gpu_memory_request (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_memory_request is None
            and "gpu_memory_request" in self.model_fields_set
        ):
            _dict["gpuMemoryRequest"] = None

        # set to None if gpu_memory_limit (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_memory_limit is None
            and "gpu_memory_limit" in self.model_fields_set
        ):
            _dict["gpuMemoryLimit"] = None

        # set to None if extended_resources (nullable) is None
        # and model_fields_set contains the field
        if (
            self.extended_resources is None
            and "extended_resources" in self.model_fields_set
        ):
            _dict["extendedResources"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ComputeFieldsRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "cpuCoreRequest": (
                    NumberRules.from_dict(obj["cpuCoreRequest"])
                    if obj.get("cpuCoreRequest") is not None
                    else None
                ),
                "cpuCoreLimit": (
                    NumberRules.from_dict(obj["cpuCoreLimit"])
                    if obj.get("cpuCoreLimit") is not None
                    else None
                ),
                "cpuMemoryRequest": (
                    QuantityRules.from_dict(obj["cpuMemoryRequest"])
                    if obj.get("cpuMemoryRequest") is not None
                    else None
                ),
                "cpuMemoryLimit": (
                    QuantityRules.from_dict(obj["cpuMemoryLimit"])
                    if obj.get("cpuMemoryLimit") is not None
                    else None
                ),
                "largeShmRequest": (
                    BooleanRules.from_dict(obj["largeShmRequest"])
                    if obj.get("largeShmRequest") is not None
                    else None
                ),
                "gpuRequestType": (
                    GpuRequestRules.from_dict(obj["gpuRequestType"])
                    if obj.get("gpuRequestType") is not None
                    else None
                ),
                "migProfile": (
                    MigProfileRules.from_dict(obj["migProfile"])
                    if obj.get("migProfile") is not None
                    else None
                ),
                "gpuDevicesRequest": (
                    IntegerRules.from_dict(obj["gpuDevicesRequest"])
                    if obj.get("gpuDevicesRequest") is not None
                    else None
                ),
                "gpuPortionRequest": (
                    NumberRules.from_dict(obj["gpuPortionRequest"])
                    if obj.get("gpuPortionRequest") is not None
                    else None
                ),
                "gpuPortionLimit": (
                    NumberRules.from_dict(obj["gpuPortionLimit"])
                    if obj.get("gpuPortionLimit") is not None
                    else None
                ),
                "gpuMemoryRequest": (
                    QuantityRules.from_dict(obj["gpuMemoryRequest"])
                    if obj.get("gpuMemoryRequest") is not None
                    else None
                ),
                "gpuMemoryLimit": (
                    QuantityRules.from_dict(obj["gpuMemoryLimit"])
                    if obj.get("gpuMemoryLimit") is not None
                    else None
                ),
                "extendedResources": (
                    ExtendedResourcesRules.from_dict(obj["extendedResources"])
                    if obj.get("extendedResources") is not None
                    else None
                ),
            }
        )
        return _obj
