# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class ConfigMap(BaseModel):
    """
    Pydantic class model representing ConfigMap.

    Parameters:
        ```python
        config_map: Optional[str]
        mount_path: Optional[str]
        sub_path: Optional[str]
        ```
        config_map: The name of the ConfigMap resource. (mandatory)
        mount_path: Local path within the workload to which the ConfigMap will be mapped to. (mandatory)
        sub_path: Path within the volume from which the container&#39;s volume should be mounted.
    Example:
        ```python
        ConfigMap(
            config_map='0',
                        mount_path='0',
                        sub_path='0'
        )
        ```
    """  # noqa: E501

    config_map: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="The name of the ConfigMap resource. (mandatory)",
        alias="configMap",
    )
    mount_path: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Local path within the workload to which the ConfigMap will be mapped to. (mandatory)",
        alias="mountPath",
    )
    sub_path: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Path within the volume from which the container's volume should be mounted.",
        alias="subPath",
    )
    __properties: ClassVar[List[str]] = ["configMap", "mountPath", "subPath"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConfigMap from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if config_map (nullable) is None
        # and model_fields_set contains the field
        if self.config_map is None and "config_map" in self.model_fields_set:
            _dict["configMap"] = None

        # set to None if mount_path (nullable) is None
        # and model_fields_set contains the field
        if self.mount_path is None and "mount_path" in self.model_fields_set:
            _dict["mountPath"] = None

        # set to None if sub_path (nullable) is None
        # and model_fields_set contains the field
        if self.sub_path is None and "sub_path" in self.model_fields_set:
            _dict["subPath"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConfigMap from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "configMap": obj.get("configMap"),
                "mountPath": obj.get("mountPath"),
                "subPath": obj.get("subPath"),
            }
        )
        return _obj
