# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.external_tool_info import ExternalToolInfo
from runai.models.internal_tool_info import InternalToolInfo
from typing import Optional, Set
from typing_extensions import Self


class Connection(BaseModel):
    """
    Pydantic class model representing Connection.

    Parameters:
        ```python
        name: str
        is_external: bool
        internal_tool_info: Optional[InternalToolInfo]
        external_tool_info: Optional[ExternalToolInfo]
        ```
        name: A unique name of this connection. This name correlates between the connection information specified at the environment asset, to the information about the connection as specified in SpecificEnv for a specific workspace.
        is_external: Internal tools (isExternal&#x3D;false) are tools that run as part of the container. External tools (isExternal&#x3D;true) run outside the container, typically in the cloud. - Default: False
        internal_tool_info: See model InternalToolInfo for more information.
        external_tool_info: See model ExternalToolInfo for more information.
    Example:
        ```python
        Connection(
            name='0',
                        is_external=True,
                        internal_tool_info=runai.models.internal_tool_info.InternalToolInfo(
                    tool_type = 'jupyter-notebook',
                    connection_type = 'LoadBalancer',
                    container_port = 1,
                    node_port_info = runai.models.node_port_info.NodePortInfo(
                        is_custom_port = True, ),
                    external_url_info = runai.models.external_url_info.ExternalUrlInfo(
                        is_custom_url = True,
                        external_url = '0', ),
                    serving_port_info = runai.models.serving_port_info.ServingPortInfo(
                        protocol = 'grpc', ), ),
                        external_tool_info=runai.models.external_tool_info.ExternalToolInfo(
                    tool_type = 'wandb',
                    external_url = 'https://wandb.com/myteam/${PROJECT_NAME}', )
        )
        ```
    """  # noqa: E501

    name: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="A unique name of this connection. This name correlates between the connection information specified at the environment asset, to the information about the connection as specified in SpecificEnv for a specific workspace."
    )
    is_external: Optional[StrictBool] = Field(
        default=False,
        description="Internal tools (isExternal=false) are tools that run as part of the container. External tools (isExternal=true) run outside the container, typically in the cloud.",
        alias="isExternal",
    )
    internal_tool_info: Optional[InternalToolInfo] = Field(
        default=None, alias="internalToolInfo"
    )
    external_tool_info: Optional[ExternalToolInfo] = Field(
        default=None, alias="externalToolInfo"
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "isExternal",
        "internalToolInfo",
        "externalToolInfo",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Connection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of internal_tool_info
        if self.internal_tool_info:
            _dict["internalToolInfo"] = self.internal_tool_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of external_tool_info
        if self.external_tool_info:
            _dict["externalToolInfo"] = self.external_tool_info.to_dict()
        # set to None if internal_tool_info (nullable) is None
        # and model_fields_set contains the field
        if (
            self.internal_tool_info is None
            and "internal_tool_info" in self.model_fields_set
        ):
            _dict["internalToolInfo"] = None

        # set to None if external_tool_info (nullable) is None
        # and model_fields_set contains the field
        if (
            self.external_tool_info is None
            and "external_tool_info" in self.model_fields_set
        ):
            _dict["externalToolInfo"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Connection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "isExternal": (
                    obj.get("isExternal")
                    if obj.get("isExternal") is not None
                    else False
                ),
                "internalToolInfo": (
                    InternalToolInfo.from_dict(obj["internalToolInfo"])
                    if obj.get("internalToolInfo") is not None
                    else None
                ),
                "externalToolInfo": (
                    ExternalToolInfo.from_dict(obj["externalToolInfo"])
                    if obj.get("externalToolInfo") is not None
                    else None
                ),
            }
        )
        return _obj
