# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class Connection1(BaseModel):
    """
    Pydantic class model representing Connection that either expose port from the container (a port is associated with a tool that the container runs), or URL to be used for connecting to an external tool that is related to the action of the container (such as Weights & Biases)..

    Parameters:
        ```python
        name: str
        tool_type: str
        connection_type: str
        url: str
        authorization_type: str
        authorized_users: List[str]
        authorized_groups: List[str]
        container_port: int
        ```
        name: See model str for more information.
        tool_type: See model str for more information.
        connection_type: See model str for more information.
        url: See model str for more information.
        authorization_type: See model str for more information.
        authorized_users: See model List[str] for more information.
        authorized_groups: See model List[str] for more information.
        container_port: The port that the container running the workload exposes.
    Example:
        ```python
        Connection1(
            name='my-pytorch-env',
                        tool_type='pytorch',
                        connection_type='ExternalUrl',
                        url='http://wandb.com/yourproject',
                        authorization_type='public',
                        authorized_users=["user@company.ai","another@company.ai"],
                        authorized_groups=["group-a","group-b"],
                        container_port=8080
        )
        ```
    """  # noqa: E501

    name: StrictStr
    tool_type: StrictStr = Field(alias="toolType")
    connection_type: StrictStr = Field(alias="connectionType")
    url: Optional[StrictStr] = None
    authorization_type: Optional[StrictStr] = Field(
        default=None, alias="authorizationType"
    )
    authorized_users: Optional[List[StrictStr]] = Field(
        default=None, alias="authorizedUsers"
    )
    authorized_groups: Optional[List[StrictStr]] = Field(
        default=None, alias="authorizedGroups"
    )
    container_port: Optional[StrictInt] = Field(
        default=None,
        description="The port that the container running the workload exposes.",
        alias="containerPort",
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "toolType",
        "connectionType",
        "url",
        "authorizationType",
        "authorizedUsers",
        "authorizedGroups",
        "containerPort",
    ]

    @field_validator("authorization_type")
    def authorization_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            ["public", "authenticatedUsers", "authorizedUsersOrGroups"]
        ):
            raise ValueError(
                "must be one of enum values ('public', 'authenticatedUsers', 'authorizedUsersOrGroups')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Connection1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Connection1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "toolType": obj.get("toolType"),
                "connectionType": obj.get("connectionType"),
                "url": obj.get("url"),
                "authorizationType": obj.get("authorizationType"),
                "authorizedUsers": obj.get("authorizedUsers"),
                "authorizedGroups": obj.get("authorizedGroups"),
                "containerPort": obj.get("containerPort"),
            }
        )
        return _obj
