# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.access_key_spec import AccessKeySpec
from runai.models.docker_registry_spec import DockerRegistrySpec
from runai.models.generic_secret_spec import GenericSecretSpec
from runai.models.password_spec import PasswordSpec
from typing import Optional, Set
from typing_extensions import Self


class CredentialsListResponseAssetSpec(BaseModel):
    """
    Pydantic class model representing CredentialsListResponseAssetSpec.

    Parameters:
        ```python
        access_key: Optional[AccessKeySpec]
        password: Optional[PasswordSpec]
        docker_registry: Optional[DockerRegistrySpec]
        generic_secret: Optional[GenericSecretSpec]
        ```
        access_key: See model AccessKeySpec for more information.
        password: See model PasswordSpec for more information.
        docker_registry: See model DockerRegistrySpec for more information.
        generic_secret: See model GenericSecretSpec for more information.
    Example:
        ```python
        CredentialsListResponseAssetSpec(
            access_key="example",
                        password="example",
                        docker_registry="example",
                        generic_secret="example"
        )
        ```
    """  # noqa: E501

    access_key: Optional[AccessKeySpec] = Field(default=None, alias="accessKey")
    password: Optional[PasswordSpec] = None
    docker_registry: Optional[DockerRegistrySpec] = Field(
        default=None, alias="dockerRegistry"
    )
    generic_secret: Optional[GenericSecretSpec] = Field(
        default=None, alias="genericSecret"
    )
    __properties: ClassVar[List[str]] = [
        "accessKey",
        "password",
        "dockerRegistry",
        "genericSecret",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CredentialsListResponseAssetSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of access_key
        if self.access_key:
            _dict["accessKey"] = self.access_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of password
        if self.password:
            _dict["password"] = self.password.to_dict()
        # override the default output from pydantic by calling `to_dict()` of docker_registry
        if self.docker_registry:
            _dict["dockerRegistry"] = self.docker_registry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of generic_secret
        if self.generic_secret:
            _dict["genericSecret"] = self.generic_secret.to_dict()
        # set to None if access_key (nullable) is None
        # and model_fields_set contains the field
        if self.access_key is None and "access_key" in self.model_fields_set:
            _dict["accessKey"] = None

        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict["password"] = None

        # set to None if docker_registry (nullable) is None
        # and model_fields_set contains the field
        if self.docker_registry is None and "docker_registry" in self.model_fields_set:
            _dict["dockerRegistry"] = None

        # set to None if generic_secret (nullable) is None
        # and model_fields_set contains the field
        if self.generic_secret is None and "generic_secret" in self.model_fields_set:
            _dict["genericSecret"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CredentialsListResponseAssetSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "accessKey": (
                    AccessKeySpec.from_dict(obj["accessKey"])
                    if obj.get("accessKey") is not None
                    else None
                ),
                "password": (
                    PasswordSpec.from_dict(obj["password"])
                    if obj.get("password") is not None
                    else None
                ),
                "dockerRegistry": (
                    DockerRegistrySpec.from_dict(obj["dockerRegistry"])
                    if obj.get("dockerRegistry") is not None
                    else None
                ),
                "genericSecret": (
                    GenericSecretSpec.from_dict(obj["genericSecret"])
                    if obj.get("genericSecret") is not None
                    else None
                ),
            }
        )
        return _obj
