# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.config_map_asset_spec import ConfigMapAssetSpec
from runai.models.git_asset_spec import GitAssetSpec
from runai.models.host_path_spec import HostPathSpec
from runai.models.nfs_asset_spec import NFSAssetSpec
from runai.models.pvc_asset_spec import PVCAssetSpec
from runai.models.s3_asset_spec import S3AssetSpec
from runai.models.secret_asset_spec import SecretAssetSpec
from typing import Optional, Set
from typing_extensions import Self


class DatasourceListResponseAssetSpec(BaseModel):
    """
    Pydantic class model representing DatasourceListResponseAssetSpec.

    Parameters:
        ```python
        host_path: Optional[HostPathSpec]
        nfs: Optional[NFSAssetSpec]
        pvc: Optional[PVCAssetSpec]
        git: Optional[GitAssetSpec]
        s3: Optional[S3AssetSpec]
        config_map: Optional[ConfigMapAssetSpec]
        secret: Optional[SecretAssetSpec]
        ```
        host_path: See model HostPathSpec for more information.
        nfs: See model NFSAssetSpec for more information.
        pvc: See model PVCAssetSpec for more information.
        git: See model GitAssetSpec for more information.
        s3: See model S3AssetSpec for more information.
        config_map: See model ConfigMapAssetSpec for more information.
        secret: See model SecretAssetSpec for more information.
    Example:
        ```python
        DatasourceListResponseAssetSpec(
            host_path="example",
                        nfs="example",
                        pvc="example",
                        git="example",
                        s3="example",
                        config_map="example",
                        secret=runai.models.secret_asset_spec.SecretAssetSpec()
        )
        ```
    """  # noqa: E501

    host_path: Optional[HostPathSpec] = Field(default=None, alias="hostPath")
    nfs: Optional[NFSAssetSpec] = None
    pvc: Optional[PVCAssetSpec] = None
    git: Optional[GitAssetSpec] = None
    s3: Optional[S3AssetSpec] = None
    config_map: Optional[ConfigMapAssetSpec] = None
    secret: Optional[SecretAssetSpec] = None
    __properties: ClassVar[List[str]] = [
        "hostPath",
        "nfs",
        "pvc",
        "git",
        "s3",
        "config_map",
        "secret",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasourceListResponseAssetSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of host_path
        if self.host_path:
            _dict["hostPath"] = self.host_path.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nfs
        if self.nfs:
            _dict["nfs"] = self.nfs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pvc
        if self.pvc:
            _dict["pvc"] = self.pvc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of git
        if self.git:
            _dict["git"] = self.git.to_dict()
        # override the default output from pydantic by calling `to_dict()` of s3
        if self.s3:
            _dict["s3"] = self.s3.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config_map
        if self.config_map:
            _dict["config_map"] = self.config_map.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secret
        if self.secret:
            _dict["secret"] = self.secret.to_dict()
        # set to None if host_path (nullable) is None
        # and model_fields_set contains the field
        if self.host_path is None and "host_path" in self.model_fields_set:
            _dict["hostPath"] = None

        # set to None if nfs (nullable) is None
        # and model_fields_set contains the field
        if self.nfs is None and "nfs" in self.model_fields_set:
            _dict["nfs"] = None

        # set to None if pvc (nullable) is None
        # and model_fields_set contains the field
        if self.pvc is None and "pvc" in self.model_fields_set:
            _dict["pvc"] = None

        # set to None if git (nullable) is None
        # and model_fields_set contains the field
        if self.git is None and "git" in self.model_fields_set:
            _dict["git"] = None

        # set to None if s3 (nullable) is None
        # and model_fields_set contains the field
        if self.s3 is None and "s3" in self.model_fields_set:
            _dict["s3"] = None

        # set to None if config_map (nullable) is None
        # and model_fields_set contains the field
        if self.config_map is None and "config_map" in self.model_fields_set:
            _dict["config_map"] = None

        # set to None if secret (nullable) is None
        # and model_fields_set contains the field
        if self.secret is None and "secret" in self.model_fields_set:
            _dict["secret"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasourceListResponseAssetSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "hostPath": (
                    HostPathSpec.from_dict(obj["hostPath"])
                    if obj.get("hostPath") is not None
                    else None
                ),
                "nfs": (
                    NFSAssetSpec.from_dict(obj["nfs"])
                    if obj.get("nfs") is not None
                    else None
                ),
                "pvc": (
                    PVCAssetSpec.from_dict(obj["pvc"])
                    if obj.get("pvc") is not None
                    else None
                ),
                "git": (
                    GitAssetSpec.from_dict(obj["git"])
                    if obj.get("git") is not None
                    else None
                ),
                "s3": (
                    S3AssetSpec.from_dict(obj["s3"])
                    if obj.get("s3") is not None
                    else None
                ),
                "config_map": (
                    ConfigMapAssetSpec.from_dict(obj["config_map"])
                    if obj.get("config_map") is not None
                    else None
                ),
                "secret": (
                    SecretAssetSpec.from_dict(obj["secret"])
                    if obj.get("secret") is not None
                    else None
                ),
            }
        )
        return _obj
