# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.condition2 import Condition2
from runai.models.datavolume_phase import DatavolumePhase
from typing import Optional, Set
from typing_extensions import Self


class DatavolumeStatusInternal(BaseModel):
    """
    Pydantic class model representing DatavolumeStatusInternal.

    Parameters:
        ```python
        phase: DatavolumePhase
        phase_message: str
        conditions: List[Condition2]
        datavolume_pvc_name: str
        datavolume_pv_name: str
        is_deleted: Optional[bool]
        ```
        phase: See model DatavolumePhase for more information.
        phase_message: Message explaining the phase of the Datavolume in the cluster
        conditions: See model List[Condition2] for more information.
        datavolume_pvc_name: The name of the copied PVC that is created in the cluster in the project namespace
        datavolume_pv_name: The name of the PV that is created in the cluster - copied from the one that was attached to the original pvc
        is_deleted: If true, the datavolume is deleted in the cluster and &#39;phase&#39; field is irrelevant.
    Example:
        ```python
        DatavolumeStatusInternal(
            phase='Ready',
                        phase_message='Failed to copy pvc to project 'project-a'',
                        conditions=[
                    runai.models.condition2.Condition2(
                        type = 'PvcsCreated',
                        status = 'False',
                        message = 'Failed to create pvc in namespace 'runai-proj1'',
                        reason = 'ErrorCreatingPvc',
                        last_transition_time = '2022-01-01T03:49:52.531Z', )
                    ],
                        datavolume_pvc_name='datavolume-pvc-1',
                        datavolume_pv_name='datavolume-pv-1',
                        is_deleted=False
        )
        ```
    """  # noqa: E501

    phase: DatavolumePhase
    phase_message: Optional[StrictStr] = Field(
        default=None,
        description="Message explaining the phase of the Datavolume in the cluster",
        alias="phaseMessage",
    )
    conditions: Optional[List[Condition2]] = None
    datavolume_pvc_name: Optional[StrictStr] = Field(
        default=None,
        description="The name of the copied PVC that is created in the cluster in the project namespace",
        alias="datavolumePvcName",
    )
    datavolume_pv_name: Optional[StrictStr] = Field(
        default=None,
        description="The name of the PV that is created in the cluster - copied from the one that was attached to the original pvc",
        alias="datavolumePvName",
    )
    is_deleted: Optional[StrictBool] = Field(
        default=None,
        description="If true, the datavolume is deleted in the cluster and 'phase' field is irrelevant.",
        alias="isDeleted",
    )
    __properties: ClassVar[List[str]] = [
        "phase",
        "phaseMessage",
        "conditions",
        "datavolumePvcName",
        "datavolumePvName",
        "isDeleted",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatavolumeStatusInternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict["conditions"] = _items
        # set to None if is_deleted (nullable) is None
        # and model_fields_set contains the field
        if self.is_deleted is None and "is_deleted" in self.model_fields_set:
            _dict["isDeleted"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatavolumeStatusInternal from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "phase": obj.get("phase"),
                "phaseMessage": obj.get("phaseMessage"),
                "conditions": (
                    [Condition2.from_dict(_item) for _item in obj["conditions"]]
                    if obj.get("conditions") is not None
                    else None
                ),
                "datavolumePvcName": obj.get("datavolumePvcName"),
                "datavolumePvName": obj.get("datavolumePvName"),
                "isDeleted": obj.get("isDeleted"),
            }
        )
        return _obj
