# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from runai.models.cluster_current_resources_inner import ClusterCurrentResourcesInner
from runai.models.department1_current_project_resources_inner import (
    Department1CurrentProjectResourcesInner,
)
from typing import Optional, Set
from typing_extensions import Self


class Department1Current(BaseModel):
    """
    Pydantic class model representing Current reported metrics data. resources holds data that is summed up to the department level and projectResources explains the division of it to projects.

    Parameters:
        ```python
        resources: List[ClusterCurrentResourcesInner]
        project_resources: List[Department1CurrentProjectResourcesInner]
        ```
        resources: See model List[ClusterCurrentResourcesInner] for more information.
        project_resources: See model List[Department1CurrentProjectResourcesInner] for more information.
    Example:
        ```python
        Department1Current(
            resources=[
                    null
                    ],
                        project_resources=[
                    null
                    ]
        )
        ```
    """  # noqa: E501

    resources: List[ClusterCurrentResourcesInner]
    project_resources: List[Department1CurrentProjectResourcesInner] = Field(
        alias="projectResources"
    )
    __properties: ClassVar[List[str]] = ["resources", "projectResources"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Department1Current from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item_resources in self.resources:
                if _item_resources:
                    _items.append(_item_resources.to_dict())
            _dict["resources"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in project_resources (list)
        _items = []
        if self.project_resources:
            for _item_project_resources in self.project_resources:
                if _item_project_resources:
                    _items.append(_item_project_resources.to_dict())
            _dict["projectResources"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Department1Current from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "resources": (
                    [
                        ClusterCurrentResourcesInner.from_dict(_item)
                        for _item in obj["resources"]
                    ]
                    if obj.get("resources") is not None
                    else None
                ),
                "projectResources": (
                    [
                        Department1CurrentProjectResourcesInner.from_dict(_item)
                        for _item in obj["projectResources"]
                    ]
                    if obj.get("projectResources") is not None
                    else None
                ),
            }
        )
        return _obj
