# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.quota_status import QuotaStatus
from runai.models.quota_status_node_pool import QuotaStatusNodePool
from typing import Optional, Set
from typing_extensions import Self


class DepartmentAllOfStatus(BaseModel):
    """
    Pydantic class model representing DepartmentAllOfStatus.

    Parameters:
        ```python
        node_pool_quota_statuses: List[QuotaStatusNodePool]
        quota_status: QuotaStatus
        ```
        node_pool_quota_statuses: See model List[QuotaStatusNodePool] for more information.
        quota_status: See model QuotaStatus for more information.
    Example:
        ```python
        DepartmentAllOfStatus(
            node_pool_quota_statuses=[
                    null
                    ],
                        quota_status=runai.models.quota_status.QuotaStatus(
                    allocated = runai.models.quota_status_resource.QuotaStatusResource(
                        gpu = 0,
                        cpu = 1000,
                        memory = 1000, ),
                    allocated_non_preemptible = runai.models.quota_status_resource.QuotaStatusResource(
                        gpu = 0,
                        cpu = 1000,
                        memory = 1000, ),
                    requested = , )
        )
        ```
    """  # noqa: E501

    node_pool_quota_statuses: Optional[List[QuotaStatusNodePool]] = Field(
        default=None, alias="nodePoolQuotaStatuses"
    )
    quota_status: Optional[QuotaStatus] = Field(default=None, alias="quotaStatus")
    __properties: ClassVar[List[str]] = ["nodePoolQuotaStatuses", "quotaStatus"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DepartmentAllOfStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in node_pool_quota_statuses (list)
        _items = []
        if self.node_pool_quota_statuses:
            for _item_node_pool_quota_statuses in self.node_pool_quota_statuses:
                if _item_node_pool_quota_statuses:
                    _items.append(_item_node_pool_quota_statuses.to_dict())
            _dict["nodePoolQuotaStatuses"] = _items
        # override the default output from pydantic by calling `to_dict()` of quota_status
        if self.quota_status:
            _dict["quotaStatus"] = self.quota_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DepartmentAllOfStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "nodePoolQuotaStatuses": (
                    [
                        QuotaStatusNodePool.from_dict(_item)
                        for _item in obj["nodePoolQuotaStatuses"]
                    ]
                    if obj.get("nodePoolQuotaStatuses") is not None
                    else None
                ),
                "quotaStatus": (
                    QuotaStatus.from_dict(obj["quotaStatus"])
                    if obj.get("quotaStatus") is not None
                    else None
                ),
            }
        )
        return _obj
