# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.department_for_list_all_of_status import DepartmentForListAllOfStatus
from runai.models.department_project_child import DepartmentProjectChild
from runai.models.node_types_per_workload import NodeTypesPerWorkload
from runai.models.overtime_data import OvertimeData
from runai.models.resources import Resources
from runai.models.scheduling_rules import SchedulingRules
from runai.models.total_resources import TotalResources
from typing import Optional, Set
from typing_extensions import Self


class DepartmentForList(BaseModel):
    """
    Pydantic class model representing DepartmentForList.

    Parameters:
        ```python
        description: str
        scheduling_rules: Optional[SchedulingRules]
        default_node_pools: Optional[List[str]]
        node_types: NodeTypesPerWorkload
        name: str
        cluster_id: str
        overtime_data: OvertimeData
        id: str
        created_at: datetime
        updated_at: datetime
        created_by: str
        updated_by: str
        children: Optional[List[DepartmentProjectChild]]
        status: Optional[DepartmentForListAllOfStatus]
        total_resources: TotalResources
        resources: List[Resources]
        ```
        description: department&#39;s description
        scheduling_rules: See model SchedulingRules for more information.
        default_node_pools: default order of node pools for workloads. will be enforced if no list is defined in workload policy
        node_types: See model NodeTypesPerWorkload for more information.
        name: See model str for more information.
        cluster_id: The id of the cluster.
        overtime_data: See model OvertimeData for more information.
        id: See model str for more information.
        created_at: See model datetime for more information.
        updated_at: See model datetime for more information.
        created_by: See model str for more information.
        updated_by: See model str for more information.
        children: See model List[DepartmentProjectChild] for more information.
        status: See model DepartmentForListAllOfStatus for more information.
        total_resources: See model TotalResources for more information.
        resources: Resources assigned to this Organization per Node Pool
    Example:
        ```python
        DepartmentForList(
            description='',
                        scheduling_rules=runai.models.scheduling_rules.SchedulingRules(
                    interactive_job_time_limit_seconds = 100,
                    interactive_job_max_idle_duration_seconds = 100,
                    interactive_job_preempt_idle_duration_seconds = 100,
                    training_job_max_idle_duration_seconds = 100,
                    training_job_time_limit_seconds = 100, ),
                        default_node_pools=[
                    ''
                    ],
                        node_types=runai.models.node_types_per_workload.NodeTypesPerWorkload(
                    training = [
                        ''
                        ],
                    workspace = [
                        ''
                        ],
                    names = {
                        'key' : ''
                        }, ),
                        name='organization1',
                        cluster_id='71f69d83-ba66-4822-adf5-55ce55efd210',
                        overtime_data=runai.models.overtime_data.OvertimeData(
                    range24h_data = runai.models.range24h_data.range24hData(),
                    range7d_data = runai.models.range7d_data.range7dData(),
                    range30d_data = runai.models.range30d_data.range30dData(), ),
                        id='50',
                        created_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        updated_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        created_by='',
                        updated_by='',
                        children=[
                    runai.models.department_project_child.DepartmentProjectChild(
                        id = '9f55253e-11ed-47c7-acef-fc4054768dbc',
                        name = 'organization1',
                        children = [
                            runai.models.department_project_child.DepartmentProjectChild(
                                id = '9f55253e-11ed-47c7-acef-fc4054768dbc',
                                name = 'organization1', )
                            ], )
                    ],
                        status=runai.models.department_for_list_all_of_status.DepartmentForList_allOf_status(
                    quota_status = runai.models.quota_status.QuotaStatus(
                        allocated = runai.models.quota_status_resource.QuotaStatusResource(
                            gpu = 0,
                            cpu = 1000,
                            memory = 1000, ),
                        allocated_non_preemptible = runai.models.quota_status_resource.QuotaStatusResource(
                            gpu = 0,
                            cpu = 1000,
                            memory = 1000, ),
                        requested = , ), ),
                        total_resources=runai.models.total_resources.TotalResources(
                    gpu_quota = 1.337,
                    cpu_quota = 1.337,
                    memory_quota = 1.337, ),
                        resources=[
                    runai.models.resources.Resources(
                        node_pool = runai.models.resources_node_pool.Resources_nodePool(
                            id = '22',
                            name = 'default', ),
                        gpu = null,
                        cpu = runai.models.cpu.cpu(),
                        memory = runai.models.resources_memory.Resources_memory(),
                        priority = 'Normal', )
                    ]
        )
        ```
    """  # noqa: E501

    description: Optional[StrictStr] = Field(
        default=None, description="department's description"
    )
    scheduling_rules: Optional[SchedulingRules] = Field(
        default=None, alias="schedulingRules"
    )
    default_node_pools: Optional[List[StrictStr]] = Field(
        default=None,
        description="default order of node pools for workloads. will be enforced if no list is defined in workload policy",
        alias="defaultNodePools",
    )
    node_types: Optional[NodeTypesPerWorkload] = Field(default=None, alias="nodeTypes")
    name: StrictStr
    cluster_id: StrictStr = Field(
        description="The id of the cluster.", alias="clusterId"
    )
    overtime_data: Optional[OvertimeData] = Field(default=None, alias="overtimeData")
    id: StrictStr
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    children: Optional[List[DepartmentProjectChild]] = None
    status: Optional[DepartmentForListAllOfStatus] = None
    total_resources: TotalResources = Field(alias="totalResources")
    resources: List[Resources] = Field(
        description="Resources assigned to this Organization per Node Pool"
    )
    __properties: ClassVar[List[str]] = [
        "description",
        "schedulingRules",
        "defaultNodePools",
        "nodeTypes",
        "name",
        "clusterId",
        "overtimeData",
        "id",
        "createdAt",
        "updatedAt",
        "createdBy",
        "updatedBy",
        "children",
        "status",
        "totalResources",
        "resources",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DepartmentForList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of scheduling_rules
        if self.scheduling_rules:
            _dict["schedulingRules"] = self.scheduling_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of node_types
        if self.node_types:
            _dict["nodeTypes"] = self.node_types.to_dict()
        # override the default output from pydantic by calling `to_dict()` of overtime_data
        if self.overtime_data:
            _dict["overtimeData"] = self.overtime_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in children (list)
        _items = []
        if self.children:
            for _item_children in self.children:
                if _item_children:
                    _items.append(_item_children.to_dict())
            _dict["children"] = _items
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_resources
        if self.total_resources:
            _dict["totalResources"] = self.total_resources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item_resources in self.resources:
                if _item_resources:
                    _items.append(_item_resources.to_dict())
            _dict["resources"] = _items
        # set to None if scheduling_rules (nullable) is None
        # and model_fields_set contains the field
        if (
            self.scheduling_rules is None
            and "scheduling_rules" in self.model_fields_set
        ):
            _dict["schedulingRules"] = None

        # set to None if default_node_pools (nullable) is None
        # and model_fields_set contains the field
        if (
            self.default_node_pools is None
            and "default_node_pools" in self.model_fields_set
        ):
            _dict["defaultNodePools"] = None

        # set to None if children (nullable) is None
        # and model_fields_set contains the field
        if self.children is None and "children" in self.model_fields_set:
            _dict["children"] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict["status"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DepartmentForList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "description": obj.get("description"),
                "schedulingRules": (
                    SchedulingRules.from_dict(obj["schedulingRules"])
                    if obj.get("schedulingRules") is not None
                    else None
                ),
                "defaultNodePools": obj.get("defaultNodePools"),
                "nodeTypes": (
                    NodeTypesPerWorkload.from_dict(obj["nodeTypes"])
                    if obj.get("nodeTypes") is not None
                    else None
                ),
                "name": obj.get("name"),
                "clusterId": obj.get("clusterId"),
                "overtimeData": (
                    OvertimeData.from_dict(obj["overtimeData"])
                    if obj.get("overtimeData") is not None
                    else None
                ),
                "id": obj.get("id"),
                "createdAt": obj.get("createdAt"),
                "updatedAt": obj.get("updatedAt"),
                "createdBy": obj.get("createdBy"),
                "updatedBy": obj.get("updatedBy"),
                "children": (
                    [
                        DepartmentProjectChild.from_dict(_item)
                        for _item in obj["children"]
                    ]
                    if obj.get("children") is not None
                    else None
                ),
                "status": (
                    DepartmentForListAllOfStatus.from_dict(obj["status"])
                    if obj.get("status") is not None
                    else None
                ),
                "totalResources": (
                    TotalResources.from_dict(obj["totalResources"])
                    if obj.get("totalResources") is not None
                    else None
                ),
                "resources": (
                    [Resources.from_dict(_item) for _item in obj["resources"]]
                    if obj.get("resources") is not None
                    else None
                ),
            }
        )
        return _obj
