# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.cluster_displayed_status import ClusterDisplayedStatus
from typing import Optional, Set
from typing_extensions import Self


class DisplayedCluster(BaseModel):
    """
    Pydantic class model representing DisplayedCluster.

    Parameters:
        ```python
        uuid: str
        tenant_id: int
        name: str
        created_at: datetime
        domain: Optional[str]
        version: Optional[str]
        status: Optional[ClusterDisplayedStatus]
        updated_at: Optional[datetime]
        deleted_at: Optional[datetime]
        last_liveness: Optional[datetime]
        delete_requested_at: Optional[datetime]
        ```
        uuid: See model str for more information.
        tenant_id: The id of the tenant.
        name: See model str for more information.
        created_at: See model datetime for more information.
        domain: See model str for more information.
        version: See model str for more information.
        status: See model ClusterDisplayedStatus for more information.
        updated_at: See model datetime for more information.
        deleted_at: See model datetime for more information.
        last_liveness: See model datetime for more information.
        delete_requested_at: the timestamp value of when the cluster deletion request was received
    Example:
        ```python
        DisplayedCluster(
            uuid='',
                        tenant_id=1001,
                        name='',
                        created_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        domain='',
                        version='',
                        status=runai.models.cluster_displayed_status.ClusterDisplayedStatus(),
                        updated_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        deleted_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        last_liveness=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        delete_requested_at=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f')
        )
        ```
    """  # noqa: E501

    uuid: StrictStr
    tenant_id: StrictInt = Field(description="The id of the tenant.", alias="tenantId")
    name: StrictStr
    created_at: datetime = Field(alias="createdAt")
    domain: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    status: Optional[ClusterDisplayedStatus] = None
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    last_liveness: Optional[datetime] = Field(default=None, alias="lastLiveness")
    delete_requested_at: Optional[datetime] = Field(
        default=None,
        description="the timestamp value of when the cluster deletion request was received",
        alias="deleteRequestedAt",
    )
    __properties: ClassVar[List[str]] = [
        "uuid",
        "tenantId",
        "name",
        "createdAt",
        "domain",
        "version",
        "status",
        "updatedAt",
        "deletedAt",
        "lastLiveness",
        "deleteRequestedAt",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DisplayedCluster from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict["domain"] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict["version"] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict["status"] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict["updatedAt"] = None

        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict["deletedAt"] = None

        # set to None if last_liveness (nullable) is None
        # and model_fields_set contains the field
        if self.last_liveness is None and "last_liveness" in self.model_fields_set:
            _dict["lastLiveness"] = None

        # set to None if delete_requested_at (nullable) is None
        # and model_fields_set contains the field
        if (
            self.delete_requested_at is None
            and "delete_requested_at" in self.model_fields_set
        ):
            _dict["deleteRequestedAt"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DisplayedCluster from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "uuid": obj.get("uuid"),
                "tenantId": obj.get("tenantId"),
                "name": obj.get("name"),
                "createdAt": obj.get("createdAt"),
                "domain": obj.get("domain"),
                "version": obj.get("version"),
                "status": (
                    ClusterDisplayedStatus.from_dict(obj["status"])
                    if obj.get("status") is not None
                    else None
                ),
                "updatedAt": obj.get("updatedAt"),
                "deletedAt": obj.get("deletedAt"),
                "lastLiveness": obj.get("lastLiveness"),
                "deleteRequestedAt": obj.get("deleteRequestedAt"),
            }
        )
        return _obj
