# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.dist_master import DistMaster
from runai.models.distributed_framework import DistributedFramework
from typing import Optional, Set
from typing_extensions import Self


class Distributed(BaseModel):
    """
    Pydantic class model representing Parameters which apply to distributed training. .

    Parameters:
        ```python
        num_workers: int
        no_master: Optional[bool]
        dist_framework: Optional[DistributedFramework]
        master: Optional[DistMaster]
        ```
        num_workers: See model int for more information.
        no_master: See model bool for more information.
        dist_framework: See model DistributedFramework for more information.
        master: See model DistMaster for more information.
    Example:
        ```python
        Distributed(
            num_workers=56,
                        no_master=True,
                        dist_framework='MPI',
                        master=runai.models.dist_master.DistMaster(
                    assets = runai.models.assets_ids.AssetsIds(
                        environment = '0',
                        compute = '',
                        datasources = [
                            runai.models.asset_id_and_kind.AssetIdAndKind(
                                id = '0',
                                kind = 'compute',
                                overrides = runai.models.data_source_overrides.DataSourceOverrides(
                                    container_path = '/container/directory', ), )
                            ],
                        workload_volumes = [
                            ''
                            ], ),
                    specific_env = runai.models.specific_run_params.SpecificRunParams(), )
        )
        ```
    """  # noqa: E501

    num_workers: Optional[StrictInt] = Field(default=None, alias="numWorkers")
    no_master: Optional[StrictBool] = Field(default=None, alias="noMaster")
    dist_framework: Optional[DistributedFramework] = Field(
        default=None, alias="distFramework"
    )
    master: Optional[DistMaster] = None
    __properties: ClassVar[List[str]] = [
        "numWorkers",
        "noMaster",
        "distFramework",
        "master",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Distributed from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of master
        if self.master:
            _dict["master"] = self.master.to_dict()
        # set to None if no_master (nullable) is None
        # and model_fields_set contains the field
        if self.no_master is None and "no_master" in self.model_fields_set:
            _dict["noMaster"] = None

        # set to None if dist_framework (nullable) is None
        # and model_fields_set contains the field
        if self.dist_framework is None and "dist_framework" in self.model_fields_set:
            _dict["distFramework"] = None

        # set to None if master (nullable) is None
        # and model_fields_set contains the field
        if self.master is None and "master" in self.model_fields_set:
            _dict["master"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Distributed from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "numWorkers": obj.get("numWorkers"),
                "noMaster": obj.get("noMaster"),
                "distFramework": obj.get("distFramework"),
                "master": (
                    DistMaster.from_dict(obj["master"])
                    if obj.get("master") is not None
                    else None
                ),
            }
        )
        return _obj
