# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.distributed_clean_pod_policy import DistributedCleanPodPolicy
from runai.models.distributed_framework import DistributedFramework
from runai.models.distributed_mpi_launcher_creation_policy import (
    DistributedMpiLauncherCreationPolicy,
)
from typing import Optional, Set
from typing_extensions import Self


class DistributedFields(BaseModel):
    """
    Pydantic class model representing DistributedFields.

    Parameters:
        ```python
        num_workers: Optional[int]
        distributed_framework: Optional[DistributedFramework]
        slots_per_worker: Optional[int]
        ssh_auth_mount_path: Optional[str]
        mpi_launcher_creation_policy: Optional[DistributedMpiLauncherCreationPolicy]
        min_replicas: Optional[int]
        max_replicas: Optional[int]
        clean_pod_policy: Optional[DistributedCleanPodPolicy]
        ```
        num_workers: the number of workers that will be allocated for running the workload.
        distributed_framework: See model DistributedFramework for more information.
        slots_per_worker: Specifies the number of slots per worker used in hostfile. Defaults to 1. (applicable only for MPI) - Default: 1
        ssh_auth_mount_path: Specifies the directory where SSH keys are mounted. (applicable only for MPI) - Default: &#39;/root/.ssh&#39;
        mpi_launcher_creation_policy: See model DistributedMpiLauncherCreationPolicy for more information.
        min_replicas: the lower limit for the number of worker pods to which the training job can scale down. (applicable only for PyTorch)
        max_replicas: the upper limit for the number of worker pods that can be set by the autoscaler. Cannot be smaller than MinReplicas. (applicable only for PyTorch)
        clean_pod_policy: See model DistributedCleanPodPolicy for more information.
    Example:
        ```python
        DistributedFields(
            num_workers=1,
                        distributed_framework='MPI',
                        slots_per_worker=1,
                        ssh_auth_mount_path='/root/.ssh',
                        mpi_launcher_creation_policy='AtStartup',
                        min_replicas=56,
                        max_replicas=56,
                        clean_pod_policy='None'
        )
        ```
    """  # noqa: E501

    num_workers: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(
        default=None,
        description="the number of workers that will be allocated for running the workload.",
        alias="numWorkers",
    )
    distributed_framework: Optional[DistributedFramework] = Field(
        default=None, alias="distributedFramework"
    )
    slots_per_worker: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(
        default=1,
        description="Specifies the number of slots per worker used in hostfile. Defaults to 1. (applicable only for MPI)",
        alias="slotsPerWorker",
    )
    ssh_auth_mount_path: Optional[StrictStr] = Field(
        default="/root/.ssh",
        description="Specifies the directory where SSH keys are mounted. (applicable only for MPI)",
        alias="sshAuthMountPath",
    )
    mpi_launcher_creation_policy: Optional[DistributedMpiLauncherCreationPolicy] = (
        Field(default=None, alias="mpiLauncherCreationPolicy")
    )
    min_replicas: Optional[StrictInt] = Field(
        default=None,
        description="the lower limit for the number of worker pods to which the training job can scale down. (applicable only for PyTorch)",
        alias="minReplicas",
    )
    max_replicas: Optional[StrictInt] = Field(
        default=None,
        description="the upper limit for the number of worker pods that can be set by the autoscaler. Cannot be smaller than MinReplicas. (applicable only for PyTorch)",
        alias="maxReplicas",
    )
    clean_pod_policy: Optional[DistributedCleanPodPolicy] = Field(
        default=None, alias="cleanPodPolicy"
    )
    __properties: ClassVar[List[str]] = [
        "numWorkers",
        "distributedFramework",
        "slotsPerWorker",
        "sshAuthMountPath",
        "mpiLauncherCreationPolicy",
        "minReplicas",
        "maxReplicas",
        "cleanPodPolicy",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DistributedFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if num_workers (nullable) is None
        # and model_fields_set contains the field
        if self.num_workers is None and "num_workers" in self.model_fields_set:
            _dict["numWorkers"] = None

        # set to None if distributed_framework (nullable) is None
        # and model_fields_set contains the field
        if (
            self.distributed_framework is None
            and "distributed_framework" in self.model_fields_set
        ):
            _dict["distributedFramework"] = None

        # set to None if slots_per_worker (nullable) is None
        # and model_fields_set contains the field
        if (
            self.slots_per_worker is None
            and "slots_per_worker" in self.model_fields_set
        ):
            _dict["slotsPerWorker"] = None

        # set to None if ssh_auth_mount_path (nullable) is None
        # and model_fields_set contains the field
        if (
            self.ssh_auth_mount_path is None
            and "ssh_auth_mount_path" in self.model_fields_set
        ):
            _dict["sshAuthMountPath"] = None

        # set to None if mpi_launcher_creation_policy (nullable) is None
        # and model_fields_set contains the field
        if (
            self.mpi_launcher_creation_policy is None
            and "mpi_launcher_creation_policy" in self.model_fields_set
        ):
            _dict["mpiLauncherCreationPolicy"] = None

        # set to None if min_replicas (nullable) is None
        # and model_fields_set contains the field
        if self.min_replicas is None and "min_replicas" in self.model_fields_set:
            _dict["minReplicas"] = None

        # set to None if max_replicas (nullable) is None
        # and model_fields_set contains the field
        if self.max_replicas is None and "max_replicas" in self.model_fields_set:
            _dict["maxReplicas"] = None

        # set to None if clean_pod_policy (nullable) is None
        # and model_fields_set contains the field
        if (
            self.clean_pod_policy is None
            and "clean_pod_policy" in self.model_fields_set
        ):
            _dict["cleanPodPolicy"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DistributedFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "numWorkers": obj.get("numWorkers"),
                "distributedFramework": obj.get("distributedFramework"),
                "slotsPerWorker": (
                    obj.get("slotsPerWorker")
                    if obj.get("slotsPerWorker") is not None
                    else 1
                ),
                "sshAuthMountPath": (
                    obj.get("sshAuthMountPath")
                    if obj.get("sshAuthMountPath") is not None
                    else "/root/.ssh"
                ),
                "mpiLauncherCreationPolicy": obj.get("mpiLauncherCreationPolicy"),
                "minReplicas": obj.get("minReplicas"),
                "maxReplicas": obj.get("maxReplicas"),
                "cleanPodPolicy": obj.get("cleanPodPolicy"),
            }
        )
        return _obj
