# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.distributed_inference_restart_policy import (
    DistributedInferenceRestartPolicy,
)
from runai.models.distributed_inference_startup_policy import (
    DistributedInferenceStartupPolicy,
)
from typing import Optional, Set
from typing_extensions import Self


class DistributedInferenceCommonSpec(BaseModel):
    """
    Pydantic class model representing DistributedInferenceCommonSpec.

    Parameters:
        ```python
        node_pools: Optional[List[str]]
        category: Optional[str]
        priority_class: Optional[str]
        serving_port: Optional[object]
        restart_policy: Optional[DistributedInferenceRestartPolicy]
        startup_policy: Optional[DistributedInferenceStartupPolicy]
        workers: Optional[int]
        replicas: Optional[int]
        ```
        node_pools: A prioritized list of node pools for the scheduler to run the workload on. The scheduler will always try to use the first node pool before moving to the next one if the first is not available.
        category: Specify the workload category assigned to the workload. Categories are used to classify and monitor different types of workloads within the NVIDIA Run:ai platform.
        priority_class: Specifies the priority class for the workload.  The default value depends on the workload type:  high for workspace workloads, low for training/distributed training workloads, and very-high for inference workloads. You can change it to any of the following valid values to adjust the workload&#39;s scheduling behavior: very-low, low, medium-low, medium, medium-high, high, very-high.
        serving_port: Defines the configuration for the inference serving endpoint. This determines how applications or services can send inference requests to the workload.
        restart_policy: See model DistributedInferenceRestartPolicy for more information. - Default: DistributedInferenceRestartPolicy.RECREATEGROUPONPODRESTART
        startup_policy: See model DistributedInferenceStartupPolicy for more information. - Default: DistributedInferenceStartupPolicy.LEADERCREATED
        workers: Specifies the number of worker nodes to run. If set to 0, only the leader node will run, and no worker pods will be created. In this case, worker spec is not required. - Default: 0
        replicas: Specifies the number of leader-worker sets to deploy. Each replica represents a group consisting of one leader pod and multiple worker pods.  For example, setting replicas: 3 will create 3 independent groups, each with its own leader and corresponding set of workers.  - Default: 1
    Example:
        ```python
        DistributedInferenceCommonSpec(
            node_pools=[my-node-pool-a, my-node-pool-b],
                        category='',
                        priority_class='',
                        serving_port=None,
                        restart_policy='RecreateGroupOnPodRestart',
                        startup_policy='LeaderCreated',
                        workers=4,
                        replicas=2
        )
        ```
    """  # noqa: E501

    node_pools: Optional[List[StrictStr]] = Field(
        default=None,
        description="A prioritized list of node pools for the scheduler to run the workload on. The scheduler will always try to use the first node pool before moving to the next one if the first is not available.",
        alias="nodePools",
    )
    category: Optional[StrictStr] = Field(
        default=None,
        description="Specify the workload category assigned to the workload. Categories are used to classify and monitor different types of workloads within the NVIDIA Run:ai platform.",
    )
    priority_class: Optional[StrictStr] = Field(
        default=None,
        description="Specifies the priority class for the workload.  The default value depends on the workload type:  high for workspace workloads, low for training/distributed training workloads, and very-high for inference workloads. You can change it to any of the following valid values to adjust the workload's scheduling behavior: very-low, low, medium-low, medium, medium-high, high, very-high.",
        alias="priorityClass",
    )
    serving_port: Optional[Dict[str, Any]] = Field(
        default=None,
        description="Defines the configuration for the inference serving endpoint. This determines how applications or services can send inference requests to the workload.",
        alias="servingPort",
    )
    restart_policy: Optional[DistributedInferenceRestartPolicy] = Field(
        default=DistributedInferenceRestartPolicy.RECREATEGROUPONPODRESTART,
        alias="restartPolicy",
    )
    startup_policy: Optional[DistributedInferenceStartupPolicy] = Field(
        default=DistributedInferenceStartupPolicy.LEADERCREATED, alias="startupPolicy"
    )
    workers: Optional[Annotated[int, Field(le=1000, strict=True, ge=0)]] = Field(
        default=0,
        description="Specifies the number of worker nodes to run. If set to 0, only the leader node will run, and no worker pods will be created. In this case, worker spec is not required.",
    )
    replicas: Optional[Annotated[int, Field(le=1000, strict=True, ge=0)]] = Field(
        default=1,
        description="Specifies the number of leader-worker sets to deploy. Each replica represents a group consisting of one leader pod and multiple worker pods.  For example, setting replicas: 3 will create 3 independent groups, each with its own leader and corresponding set of workers. ",
    )
    __properties: ClassVar[List[str]] = [
        "nodePools",
        "category",
        "priorityClass",
        "servingPort",
        "restartPolicy",
        "startupPolicy",
        "workers",
        "replicas",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DistributedInferenceCommonSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if node_pools (nullable) is None
        # and model_fields_set contains the field
        if self.node_pools is None and "node_pools" in self.model_fields_set:
            _dict["nodePools"] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict["category"] = None

        # set to None if priority_class (nullable) is None
        # and model_fields_set contains the field
        if self.priority_class is None and "priority_class" in self.model_fields_set:
            _dict["priorityClass"] = None

        # set to None if serving_port (nullable) is None
        # and model_fields_set contains the field
        if self.serving_port is None and "serving_port" in self.model_fields_set:
            _dict["servingPort"] = None

        # set to None if restart_policy (nullable) is None
        # and model_fields_set contains the field
        if self.restart_policy is None and "restart_policy" in self.model_fields_set:
            _dict["restartPolicy"] = None

        # set to None if startup_policy (nullable) is None
        # and model_fields_set contains the field
        if self.startup_policy is None and "startup_policy" in self.model_fields_set:
            _dict["startupPolicy"] = None

        # set to None if workers (nullable) is None
        # and model_fields_set contains the field
        if self.workers is None and "workers" in self.model_fields_set:
            _dict["workers"] = None

        # set to None if replicas (nullable) is None
        # and model_fields_set contains the field
        if self.replicas is None and "replicas" in self.model_fields_set:
            _dict["replicas"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DistributedInferenceCommonSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "nodePools": obj.get("nodePools"),
                "category": obj.get("category"),
                "priorityClass": obj.get("priorityClass"),
                "servingPort": obj.get("servingPort"),
                "restartPolicy": (
                    obj.get("restartPolicy")
                    if obj.get("restartPolicy") is not None
                    else DistributedInferenceRestartPolicy.RECREATEGROUPONPODRESTART
                ),
                "startupPolicy": (
                    obj.get("startupPolicy")
                    if obj.get("startupPolicy") is not None
                    else DistributedInferenceStartupPolicy.LEADERCREATED
                ),
                "workers": obj.get("workers") if obj.get("workers") is not None else 0,
                "replicas": (
                    obj.get("replicas") if obj.get("replicas") is not None else 1
                ),
            }
        )
        return _obj
