# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.distributed_inference_serving_port_access_authorization_type_enum import (
    DistributedInferenceServingPortAccessAuthorizationTypeEnum,
)
from typing import Optional, Set
from typing_extensions import Self


class DistributedInferenceServingPortAccess(BaseModel):
    """
    Pydantic class model representing DistributedInferenceServingPortAccess.

    Parameters:
        ```python
        authorization_type: Optional[DistributedInferenceServingPortAccessAuthorizationTypeEnum]
        authorized_users: Optional[List[str]]
        authorized_groups: Optional[List[str]]
        expose_externally: Optional[bool]
        exposed_url: Optional[str]
        ```
        authorization_type: See model DistributedInferenceServingPortAccessAuthorizationTypeEnum for more information.
        authorized_users: A list of users allowed to send inference requests to the serving endpoint. &#x60;Note:&#x60; Cannot be used together with authorizedGroups.
        authorized_groups: A list of user groups allowed to send inference requests to the serving endpoint. &#x60;Note:&#x60; Cannot be used together with authorizedUsers.
        expose_externally: Indicates whether the inference serving endpoint should be accessible outside the cluster. If set to true, the endpoint will be exposed externally. To enable external access, your administrator must configure the cluster as described in the [inference requirements](https://run-ai-docs.nvidia.com/self-hosted/getting-started/installation/system-requirements#inference). section. - Default: True
        exposed_url: The custom URL to use for the serving port. If empty (default), an autogenerated URL will be used.
    Example:
        ```python
        DistributedInferenceServingPortAccess(
            authorization_type='public',
                        authorized_users=["user.a@example.com","user.b@example.com"],
                        authorized_groups=["group-a","group-b"],
                        expose_externally=True,
                        exposed_url=''
        )
        ```
    """  # noqa: E501

    authorization_type: Optional[
        DistributedInferenceServingPortAccessAuthorizationTypeEnum
    ] = Field(default=None, alias="authorizationType")
    authorized_users: Optional[List[StrictStr]] = Field(
        default=None,
        description="A list of users allowed to send inference requests to the serving endpoint. `Note:` Cannot be used together with authorizedGroups.",
        alias="authorizedUsers",
    )
    authorized_groups: Optional[List[StrictStr]] = Field(
        default=None,
        description="A list of user groups allowed to send inference requests to the serving endpoint. `Note:` Cannot be used together with authorizedUsers.",
        alias="authorizedGroups",
    )
    expose_externally: Optional[StrictBool] = Field(
        default=True,
        description="Indicates whether the inference serving endpoint should be accessible outside the cluster. If set to true, the endpoint will be exposed externally. To enable external access, your administrator must configure the cluster as described in the [inference requirements](https://run-ai-docs.nvidia.com/self-hosted/getting-started/installation/system-requirements#inference). section.",
        alias="exposeExternally",
    )
    exposed_url: Optional[StrictStr] = Field(
        default=None,
        description="The custom URL to use for the serving port. If empty (default), an autogenerated URL will be used.",
        alias="exposedUrl",
    )
    __properties: ClassVar[List[str]] = [
        "authorizationType",
        "authorizedUsers",
        "authorizedGroups",
        "exposeExternally",
        "exposedUrl",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DistributedInferenceServingPortAccess from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if authorization_type (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorization_type is None
            and "authorization_type" in self.model_fields_set
        ):
            _dict["authorizationType"] = None

        # set to None if authorized_users (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_users is None
            and "authorized_users" in self.model_fields_set
        ):
            _dict["authorizedUsers"] = None

        # set to None if authorized_groups (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_groups is None
            and "authorized_groups" in self.model_fields_set
        ):
            _dict["authorizedGroups"] = None

        # set to None if expose_externally (nullable) is None
        # and model_fields_set contains the field
        if (
            self.expose_externally is None
            and "expose_externally" in self.model_fields_set
        ):
            _dict["exposeExternally"] = None

        # set to None if exposed_url (nullable) is None
        # and model_fields_set contains the field
        if self.exposed_url is None and "exposed_url" in self.model_fields_set:
            _dict["exposedUrl"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DistributedInferenceServingPortAccess from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "authorizationType": obj.get("authorizationType"),
                "authorizedUsers": obj.get("authorizedUsers"),
                "authorizedGroups": obj.get("authorizedGroups"),
                "exposeExternally": (
                    obj.get("exposeExternally")
                    if obj.get("exposeExternally") is not None
                    else True
                ),
                "exposedUrl": obj.get("exposedUrl"),
            }
        )
        return _obj
