# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.distributed_inference_leader_worker_spec import (
    DistributedInferenceLeaderWorkerSpec,
)
from typing import Optional, Set
from typing_extensions import Self


class DistributedInferenceWorkerSpecFields(BaseModel):
    """
    Pydantic class model representing DistributedInferenceWorkerSpecFields.

    Parameters:
        ```python
        worker: Optional[DistributedInferenceLeaderWorkerSpec]
        ```
        worker: Defines the pod specification for the workers. Required only if the number of workers is greater than 0.
    Example:
        ```python
        DistributedInferenceWorkerSpecFields(
            worker=runai.models.distributed_inference_leader_worker_spec.DistributedInferenceLeaderWorkerSpec()
        )
        ```
    """  # noqa: E501

    worker: Optional[DistributedInferenceLeaderWorkerSpec] = Field(
        default=None,
        description="Defines the pod specification for the workers. Required only if the number of workers is greater than 0.",
    )
    __properties: ClassVar[List[str]] = ["worker"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DistributedInferenceWorkerSpecFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of worker
        if self.worker:
            _dict["worker"] = self.worker.to_dict()
        # set to None if worker (nullable) is None
        # and model_fields_set contains the field
        if self.worker is None and "worker" in self.model_fields_set:
            _dict["worker"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DistributedInferenceWorkerSpecFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "worker": (
                    DistributedInferenceLeaderWorkerSpec.from_dict(obj["worker"])
                    if obj.get("worker") is not None
                    else None
                )
            }
        )
        return _obj
