# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.distributed_imposed_assets import DistributedImposedAssets
from runai.models.distributed_policy_defaults_v2 import DistributedPolicyDefaultsV2
from runai.models.distributed_policy_rules_v2 import DistributedPolicyRulesV2
from runai.models.policy_validation_status import PolicyValidationStatus
from typing import Optional, Set
from typing_extensions import Self


class DistributedPolicyDefaultsAndRulesV2(BaseModel):
    """
    Pydantic class model representing DistributedPolicyDefaultsAndRulesV2.

    Parameters:
        ```python
        defaults: Optional[DistributedPolicyDefaultsV2]
        rules: Optional[DistributedPolicyRulesV2]
        imposed_assets: Optional[DistributedImposedAssets]
        status: Optional[PolicyValidationStatus]
        ```
        defaults: See model DistributedPolicyDefaultsV2 for more information.
        rules: See model DistributedPolicyRulesV2 for more information.
        imposed_assets: See model DistributedImposedAssets for more information.
        status: See model PolicyValidationStatus for more information.
    Example:
        ```python
        DistributedPolicyDefaultsAndRulesV2(
            defaults=runai.models.distributed_policy_defaults_v2.DistributedPolicyDefaultsV2(
                    worker = runai.models.distributed_policy_defaults_v2_worker.DistributedPolicyDefaultsV2_worker(),
                    master = runai.models.replica_defaults_v2.ReplicaDefaultsV2(), ),
                        rules=runai.models.distributed_policy_rules_v2.DistributedPolicyRulesV2(
                    worker = runai.models.distributed_policy_rules_v2_worker.DistributedPolicyRulesV2_worker(),
                    master = runai.models.replica_rules_v2.ReplicaRulesV2(), ),
                        imposed_assets=runai.models.distributed_imposed_assets.DistributedImposedAssets(
                    worker = [
                        ''
                        ],
                    master = [
                        ''
                        ], ),
                        status=runai.models.policy_validation_status.PolicyValidationStatus(
                    validation = runai.models.policy_validation_status_validation.PolicyValidationStatus_validation(
                        error_message = '', ), )
        )
        ```
    """  # noqa: E501

    defaults: Optional[DistributedPolicyDefaultsV2] = None
    rules: Optional[DistributedPolicyRulesV2] = None
    imposed_assets: Optional[DistributedImposedAssets] = Field(
        default=None, alias="imposedAssets"
    )
    status: Optional[PolicyValidationStatus] = None
    __properties: ClassVar[List[str]] = ["defaults", "rules", "imposedAssets", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DistributedPolicyDefaultsAndRulesV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of defaults
        if self.defaults:
            _dict["defaults"] = self.defaults.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rules
        if self.rules:
            _dict["rules"] = self.rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of imposed_assets
        if self.imposed_assets:
            _dict["imposedAssets"] = self.imposed_assets.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # set to None if defaults (nullable) is None
        # and model_fields_set contains the field
        if self.defaults is None and "defaults" in self.model_fields_set:
            _dict["defaults"] = None

        # set to None if rules (nullable) is None
        # and model_fields_set contains the field
        if self.rules is None and "rules" in self.model_fields_set:
            _dict["rules"] = None

        # set to None if imposed_assets (nullable) is None
        # and model_fields_set contains the field
        if self.imposed_assets is None and "imposed_assets" in self.model_fields_set:
            _dict["imposedAssets"] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict["status"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DistributedPolicyDefaultsAndRulesV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "defaults": (
                    DistributedPolicyDefaultsV2.from_dict(obj["defaults"])
                    if obj.get("defaults") is not None
                    else None
                ),
                "rules": (
                    DistributedPolicyRulesV2.from_dict(obj["rules"])
                    if obj.get("rules") is not None
                    else None
                ),
                "imposedAssets": (
                    DistributedImposedAssets.from_dict(obj["imposedAssets"])
                    if obj.get("imposedAssets") is not None
                    else None
                ),
                "status": (
                    PolicyValidationStatus.from_dict(obj["status"])
                    if obj.get("status") is not None
                    else None
                ),
            }
        )
        return _obj
