# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.email_auth_type import EmailAuthType
from typing import Optional, Set
from typing_extensions import Self


class EmailNotificationChannelConfig(BaseModel):
    """
    Pydantic class model representing EmailNotificationChannelConfig.

    Parameters:
        ```python
        username: str
        password: str
        smtp_host: str
        var_from: str
        smtp_port: int
        auth_type: EmailAuthType
        smtp_tls_enabled: Optional[bool]
        recipients: List[str]
        from_display_name: str
        direct_notifications: Optional[bool]
        use_attachments: Optional[bool]
        subject: str
        ```
        username: See model str for more information.
        password: See model str for more information.
        smtp_host: See model str for more information.
        var_from: See model str for more information.
        smtp_port: See model int for more information. - Default: 587
        auth_type: See model EmailAuthType for more information. - Default: EmailAuthType.AUTH_LOGIN
        smtp_tls_enabled: See model bool for more information.
        recipients: See model List[str] for more information. - Default: []
        from_display_name: See model str for more information. - Default: &#39;Run:ai&#39;
        direct_notifications: See model bool for more information.
        use_attachments: See model bool for more information.
        subject: See model str for more information. - Default: &#39;Run:ai notification - {{ .category }} {{ .reason }}&#39;
    Example:
        ```python
        EmailNotificationChannelConfig(
            username='',
                        password='',
                        smtp_host='',
                        var_from='',
                        smtp_port=56,
                        auth_type='auth_login',
                        smtp_tls_enabled=True,
                        recipients=[
                    ''
                    ],
                        from_display_name='Run:ai',
                        direct_notifications=True,
                        use_attachments=True,
                        subject='Run:ai notification - {{ .category }} {{ .reason }}'
        )
        ```
    """  # noqa: E501

    username: Optional[StrictStr] = None
    password: Optional[StrictStr] = None
    smtp_host: Optional[StrictStr] = Field(default=None, alias="smtpHost")
    var_from: Optional[StrictStr] = Field(default=None, alias="from")
    smtp_port: Optional[StrictInt] = Field(default=587, alias="smtpPort")
    auth_type: Optional[EmailAuthType] = Field(
        default=EmailAuthType.AUTH_LOGIN, alias="authType"
    )
    smtp_tls_enabled: Optional[StrictBool] = Field(default=None, alias="smtpTlsEnabled")
    recipients: Optional[List[StrictStr]] = None
    from_display_name: Optional[StrictStr] = Field(
        default="Run:ai", alias="fromDisplayName"
    )
    direct_notifications: Optional[StrictBool] = Field(
        default=None, alias="directNotifications"
    )
    use_attachments: Optional[StrictBool] = Field(default=None, alias="useAttachments")
    subject: Optional[StrictStr] = "Run:ai notification - {{ .category }} {{ .reason }}"
    __properties: ClassVar[List[str]] = [
        "username",
        "password",
        "smtpHost",
        "from",
        "smtpPort",
        "authType",
        "smtpTlsEnabled",
        "recipients",
        "fromDisplayName",
        "directNotifications",
        "useAttachments",
        "subject",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailNotificationChannelConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if smtp_tls_enabled (nullable) is None
        # and model_fields_set contains the field
        if (
            self.smtp_tls_enabled is None
            and "smtp_tls_enabled" in self.model_fields_set
        ):
            _dict["smtpTlsEnabled"] = None

        # set to None if direct_notifications (nullable) is None
        # and model_fields_set contains the field
        if (
            self.direct_notifications is None
            and "direct_notifications" in self.model_fields_set
        ):
            _dict["directNotifications"] = None

        # set to None if use_attachments (nullable) is None
        # and model_fields_set contains the field
        if self.use_attachments is None and "use_attachments" in self.model_fields_set:
            _dict["useAttachments"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailNotificationChannelConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "username": obj.get("username"),
                "password": obj.get("password"),
                "smtpHost": obj.get("smtpHost"),
                "from": obj.get("from"),
                "smtpPort": (
                    obj.get("smtpPort") if obj.get("smtpPort") is not None else 587
                ),
                "authType": (
                    obj.get("authType")
                    if obj.get("authType") is not None
                    else EmailAuthType.AUTH_LOGIN
                ),
                "smtpTlsEnabled": obj.get("smtpTlsEnabled"),
                "recipients": obj.get("recipients"),
                "fromDisplayName": (
                    obj.get("fromDisplayName")
                    if obj.get("fromDisplayName") is not None
                    else "Run:ai"
                ),
                "directNotifications": obj.get("directNotifications"),
                "useAttachments": obj.get("useAttachments"),
                "subject": (
                    obj.get("subject")
                    if obj.get("subject") is not None
                    else "Run:ai notification - {{ .category }} {{ .reason }}"
                ),
            }
        )
        return _obj
