# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.environment_variable_config_map import EnvironmentVariableConfigMap
from runai.models.environment_variable_credential import EnvironmentVariableCredential
from runai.models.environment_variable_pod_field_reference import (
    EnvironmentVariablePodFieldReference,
)
from typing import Optional, Set
from typing_extensions import Self


class EnvironmentVariableOfAsset(BaseModel):
    """
    Pydantic class model representing Details of an environment variable which is populated into the container..

    Parameters:
        ```python
        name: Optional[str]
        value: Optional[str]
        credential: Optional[EnvironmentVariableCredential]
        config_map: Optional[EnvironmentVariableConfigMap]
        pod_field_ref: Optional[EnvironmentVariablePodFieldReference]
        exclude: Optional[bool]
        description: Optional[str]
        ```
        name: The name of the environment variable. (mandatory)
        value: The value of the environment variable. (mutually exclusive with credential, configMap and podFieldRef)
        credential: See model EnvironmentVariableCredential for more information.
        config_map: See model EnvironmentVariableConfigMap for more information.
        pod_field_ref: See model EnvironmentVariablePodFieldReference for more information.
        exclude: Use &#39;true&#39; in case the environment variable is defined in defaults of the policy, and you wish to exclude it from the workload.
        description: Description of the environment variable.
    Example:
        ```python
        EnvironmentVariableOfAsset(
            name='HOME',
                        value='/home/my-folder',
                        credential=runai.models.environment_variable_credential.EnvironmentVariableCredential(
                    asset_id = '0',
                    key = 'POSTGRES_PASSWORD', ),
                        config_map=runai.models.environment_variable_config_map.EnvironmentVariableConfigMap(
                    name = 'my-config-map',
                    key = 'MY_POSTGRES_SCHEMA', ),
                        pod_field_ref=runai.models.environment_variable_pod_field_reference.EnvironmentVariablePodFieldReference(
                    path = 'metadata.name', ),
                        exclude=False,
                        description='Home directory of the user.'
        )
        ```
    """  # noqa: E501

    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None, description="The name of the environment variable. (mandatory)"
    )
    value: Optional[StrictStr] = Field(
        default=None,
        description="The value of the environment variable. (mutually exclusive with credential, configMap and podFieldRef)",
    )
    credential: Optional[EnvironmentVariableCredential] = None
    config_map: Optional[EnvironmentVariableConfigMap] = Field(
        default=None, alias="configMap"
    )
    pod_field_ref: Optional[EnvironmentVariablePodFieldReference] = Field(
        default=None, alias="podFieldRef"
    )
    exclude: Optional[StrictBool] = Field(
        default=None,
        description="Use 'true' in case the environment variable is defined in defaults of the policy, and you wish to exclude it from the workload.",
    )
    description: Optional[StrictStr] = Field(
        default=None, description="Description of the environment variable."
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "value",
        "credential",
        "configMap",
        "podFieldRef",
        "exclude",
        "description",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EnvironmentVariableOfAsset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict["credential"] = self.credential.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config_map
        if self.config_map:
            _dict["configMap"] = self.config_map.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pod_field_ref
        if self.pod_field_ref:
            _dict["podFieldRef"] = self.pod_field_ref.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict["name"] = None

        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict["value"] = None

        # set to None if credential (nullable) is None
        # and model_fields_set contains the field
        if self.credential is None and "credential" in self.model_fields_set:
            _dict["credential"] = None

        # set to None if config_map (nullable) is None
        # and model_fields_set contains the field
        if self.config_map is None and "config_map" in self.model_fields_set:
            _dict["configMap"] = None

        # set to None if pod_field_ref (nullable) is None
        # and model_fields_set contains the field
        if self.pod_field_ref is None and "pod_field_ref" in self.model_fields_set:
            _dict["podFieldRef"] = None

        # set to None if exclude (nullable) is None
        # and model_fields_set contains the field
        if self.exclude is None and "exclude" in self.model_fields_set:
            _dict["exclude"] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EnvironmentVariableOfAsset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "value": obj.get("value"),
                "credential": (
                    EnvironmentVariableCredential.from_dict(obj["credential"])
                    if obj.get("credential") is not None
                    else None
                ),
                "configMap": (
                    EnvironmentVariableConfigMap.from_dict(obj["configMap"])
                    if obj.get("configMap") is not None
                    else None
                ),
                "podFieldRef": (
                    EnvironmentVariablePodFieldReference.from_dict(obj["podFieldRef"])
                    if obj.get("podFieldRef") is not None
                    else None
                ),
                "exclude": obj.get("exclude"),
                "description": obj.get("description"),
            }
        )
        return _obj
