# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.involved_object import InvolvedObject
from typing import Optional, Set
from typing_extensions import Self


class Event1(BaseModel):
    """
    Pydantic class model representing Event1.

    Parameters:
        ```python
        created_at: datetime
        id: str
        type: str
        cluster_id: str
        message: str
        reason: str
        source: str
        involved_object: InvolvedObject
        ```
        created_at: See model datetime for more information.
        id: See model str for more information.
        type: See model str for more information.
        cluster_id: The id of the cluster.
        message: See model str for more information.
        reason: See model str for more information.
        source: See model str for more information.
        involved_object: See model InvolvedObject for more information.
    Example:
        ```python
        Event1(
            created_at='2022-01-01T03:49:52.531Z',
                        id='',
                        type='Normal',
                        cluster_id='71f69d83-ba66-4822-adf5-55ce55efd210',
                        message='Started container z',
                        reason='Started',
                        source='kubelet',
                        involved_object=runai.models.involved_object.InvolvedObject(
                    uid = '',
                    kind = 'Pod',
                    name = 'test-0-1',
                    namespace = 'runai-test', )
        )
        ```
    """  # noqa: E501

    created_at: datetime = Field(alias="createdAt")
    id: Optional[StrictStr] = None
    type: StrictStr
    cluster_id: StrictStr = Field(
        description="The id of the cluster.", alias="clusterId"
    )
    message: StrictStr
    reason: Optional[StrictStr] = None
    source: Optional[StrictStr] = None
    involved_object: Optional[InvolvedObject] = Field(
        default=None, alias="involvedObject"
    )
    __properties: ClassVar[List[str]] = [
        "createdAt",
        "id",
        "type",
        "clusterId",
        "message",
        "reason",
        "source",
        "involvedObject",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Event1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of involved_object
        if self.involved_object:
            _dict["involvedObject"] = self.involved_object.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Event1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "createdAt": obj.get("createdAt"),
                "id": obj.get("id"),
                "type": obj.get("type"),
                "clusterId": obj.get("clusterId"),
                "message": obj.get("message"),
                "reason": obj.get("reason"),
                "source": obj.get("source"),
                "involvedObject": (
                    InvolvedObject.from_dict(obj["involvedObject"])
                    if obj.get("involvedObject") is not None
                    else None
                ),
            }
        )
        return _obj
