# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.array_rules import ArrayRules
from runai.models.boolean_rules import BooleanRules
from runai.models.integer_rules import IntegerRules
from runai.models.string_rules import StringRules
from typing import Optional, Set
from typing_extensions import Self


class ExposedUrlRules(BaseModel):
    """
    Pydantic class model representing Rules for the attributed of exposedUrls.

    Parameters:
        ```python
        container: Optional[IntegerRules]
        custom_url: Optional[BooleanRules]
        url: Optional[StringRules]
        authorized_users: Optional[ArrayRules]
        tool_type: Optional[StringRules]
        tool_name: Optional[StringRules]
        ```
        container: See model IntegerRules for more information.
        custom_url: See model BooleanRules for more information.
        url: See model StringRules for more information.
        authorized_users: See model ArrayRules for more information.
        tool_type: See model StringRules for more information.
        tool_name: See model StringRules for more information.
    Example:
        ```python
        ExposedUrlRules(
            container=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        custom_url=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, ),
                        url=runai.models.string_rules.StringRules(),
                        authorized_users=runai.models.array_rules.ArrayRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    options = [
                        {"value":"value","displayed":"A description of the value."}
                        ],
                    can_edit = True, ),
                        tool_type=runai.models.string_rules.StringRules(),
                        tool_name=runai.models.string_rules.StringRules()
        )
        ```
    """  # noqa: E501

    container: Optional[IntegerRules] = None
    custom_url: Optional[BooleanRules] = Field(default=None, alias="customUrl")
    url: Optional[StringRules] = None
    authorized_users: Optional[ArrayRules] = Field(
        default=None, alias="authorizedUsers"
    )
    tool_type: Optional[StringRules] = Field(default=None, alias="toolType")
    tool_name: Optional[StringRules] = Field(default=None, alias="toolName")
    __properties: ClassVar[List[str]] = [
        "container",
        "customUrl",
        "url",
        "authorizedUsers",
        "toolType",
        "toolName",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExposedUrlRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of container
        if self.container:
            _dict["container"] = self.container.to_dict()
        # override the default output from pydantic by calling `to_dict()` of custom_url
        if self.custom_url:
            _dict["customUrl"] = self.custom_url.to_dict()
        # override the default output from pydantic by calling `to_dict()` of url
        if self.url:
            _dict["url"] = self.url.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authorized_users
        if self.authorized_users:
            _dict["authorizedUsers"] = self.authorized_users.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tool_type
        if self.tool_type:
            _dict["toolType"] = self.tool_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tool_name
        if self.tool_name:
            _dict["toolName"] = self.tool_name.to_dict()
        # set to None if container (nullable) is None
        # and model_fields_set contains the field
        if self.container is None and "container" in self.model_fields_set:
            _dict["container"] = None

        # set to None if custom_url (nullable) is None
        # and model_fields_set contains the field
        if self.custom_url is None and "custom_url" in self.model_fields_set:
            _dict["customUrl"] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict["url"] = None

        # set to None if authorized_users (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_users is None
            and "authorized_users" in self.model_fields_set
        ):
            _dict["authorizedUsers"] = None

        # set to None if tool_type (nullable) is None
        # and model_fields_set contains the field
        if self.tool_type is None and "tool_type" in self.model_fields_set:
            _dict["toolType"] = None

        # set to None if tool_name (nullable) is None
        # and model_fields_set contains the field
        if self.tool_name is None and "tool_name" in self.model_fields_set:
            _dict["toolName"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExposedUrlRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "container": (
                    IntegerRules.from_dict(obj["container"])
                    if obj.get("container") is not None
                    else None
                ),
                "customUrl": (
                    BooleanRules.from_dict(obj["customUrl"])
                    if obj.get("customUrl") is not None
                    else None
                ),
                "url": (
                    StringRules.from_dict(obj["url"])
                    if obj.get("url") is not None
                    else None
                ),
                "authorizedUsers": (
                    ArrayRules.from_dict(obj["authorizedUsers"])
                    if obj.get("authorizedUsers") is not None
                    else None
                ),
                "toolType": (
                    StringRules.from_dict(obj["toolType"])
                    if obj.get("toolType") is not None
                    else None
                ),
                "toolName": (
                    StringRules.from_dict(obj["toolName"])
                    if obj.get("toolName") is not None
                    else None
                ),
            }
        )
        return _obj
