# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.audit_log import AuditLog
from typing import Optional, Set
from typing_extensions import Self


class GetAuditLogs200Response(BaseModel):
    """
    Pydantic class model representing GetAuditLogs200Response.

    Parameters:
        ```python
        total: int
        next: int
        audit_logs: List[AuditLog]
        ```
        total: See model int for more information.
        next: See model int for more information.
        audit_logs: See model List[AuditLog] for more information.
    Example:
        ```python
        GetAuditLogs200Response(
            total=2000,
                        next=100,
                        audit_logs=[
                    runai.models.audit_log.AuditLog(
                        id = '',
                        timestamp = '2022-01-01T03:49:52.531Z',
                        tenant_id = '12345',
                        subject = 'researcher@run.ai',
                        subject_type = 'User',
                        source_ip = '',
                        action = 'create',
                        http_method = 'GET',
                        url = '',
                        entity_type = 'project',
                        entity_name = 'project-1',
                        entity_id = '1234',
                        result = 'Succeeded',
                        http_status_code = 200,
                        cluster_name = 'my favorite cluster',
                        cluster_id = '',
                        request_id = 'bb0c4742-e52f-4d5e-bfee-2c4ff57c339c',
                        metadata = {
                            'key' : ''
                            }, )
                    ]
        )
        ```
    """  # noqa: E501

    total: Optional[StrictInt] = None
    next: Optional[StrictInt] = None
    audit_logs: Optional[List[AuditLog]] = None
    __properties: ClassVar[List[str]] = ["total", "next", "audit_logs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAuditLogs200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in audit_logs (list)
        _items = []
        if self.audit_logs:
            for _item_audit_logs in self.audit_logs:
                if _item_audit_logs:
                    _items.append(_item_audit_logs.to_dict())
            _dict["audit_logs"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAuditLogs200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "total": obj.get("total"),
                "next": obj.get("next"),
                "audit_logs": (
                    [AuditLog.from_dict(_item) for _item in obj["audit_logs"]]
                    if obj.get("audit_logs") is not None
                    else None
                ),
            }
        )
        return _obj
