# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class GitInstance(BaseModel):
    """
    Pydantic class model representing GitInstance.

    Parameters:
        ```python
        name: Optional[str]
        repository: Optional[str]
        branch: Optional[str]
        revision: Optional[str]
        path: Optional[str]
        password_secret: Optional[str]
        secret_key_of_user: Optional[str]
        secret_key_of_password: Optional[str]
        exclude: Optional[bool]
        ```
        name: unique name to identify the instance. primarily used for policy locked rules.
        repository: URL to a remote Git repository. The content of this repository will be mapped to the container running the workload. (mandatory)
        branch: Specific branch to synchronize the repository from.
        revision: Specific revision to synchronize the repository from.
        path: Local path within the workload to which the Git repository will be mapped (mandatory).
        password_secret: Secret containing the credentials of the repository (needed for non public repository which requires authentication).
        secret_key_of_user: The key to use for loading the user name from the secret. The default is &#x60;User&#x60;.
        secret_key_of_password: The key to use for loading the password from the secret. The default is &#x60;Password&#x60;.
        exclude: Use &#39;true&#39; in case the item is defined in defaults of the policy, and you wish to exclude it from the workload. - Default: False
    Example:
        ```python
        GitInstance(
            name='storage-instance-a',
                        repository='https://github.com/my-git/my-repo',
                        branch='main',
                        revision='0',
                        path='/container/my-repository',
                        password_secret='my-password-secret',
                        secret_key_of_user='User',
                        secret_key_of_password='Password',
                        exclude=False
        )
        ```
    """  # noqa: E501

    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="unique name to identify the instance. primarily used for policy locked rules.",
    )
    repository: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="URL to a remote Git repository. The content of this repository will be mapped to the container running the workload. (mandatory)",
    )
    branch: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None, description="Specific branch to synchronize the repository from."
    )
    revision: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Specific revision to synchronize the repository from.",
    )
    path: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Local path within the workload to which the Git repository will be mapped (mandatory).",
    )
    password_secret: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Secret containing the credentials of the repository (needed for non public repository which requires authentication).",
        alias="passwordSecret",
    )
    secret_key_of_user: Optional[Annotated[str, Field(min_length=1, strict=True)]] = (
        Field(
            default=None,
            description="The key to use for loading the user name from the secret. The default is `User`.",
            alias="secretKeyOfUser",
        )
    )
    secret_key_of_password: Optional[
        Annotated[str, Field(min_length=1, strict=True)]
    ] = Field(
        default=None,
        description="The key to use for loading the password from the secret. The default is `Password`.",
        alias="secretKeyOfPassword",
    )
    exclude: Optional[StrictBool] = Field(
        default=False,
        description="Use 'true' in case the item is defined in defaults of the policy, and you wish to exclude it from the workload.",
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "repository",
        "branch",
        "revision",
        "path",
        "passwordSecret",
        "secretKeyOfUser",
        "secretKeyOfPassword",
        "exclude",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GitInstance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict["name"] = None

        # set to None if repository (nullable) is None
        # and model_fields_set contains the field
        if self.repository is None and "repository" in self.model_fields_set:
            _dict["repository"] = None

        # set to None if branch (nullable) is None
        # and model_fields_set contains the field
        if self.branch is None and "branch" in self.model_fields_set:
            _dict["branch"] = None

        # set to None if revision (nullable) is None
        # and model_fields_set contains the field
        if self.revision is None and "revision" in self.model_fields_set:
            _dict["revision"] = None

        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict["path"] = None

        # set to None if password_secret (nullable) is None
        # and model_fields_set contains the field
        if self.password_secret is None and "password_secret" in self.model_fields_set:
            _dict["passwordSecret"] = None

        # set to None if secret_key_of_user (nullable) is None
        # and model_fields_set contains the field
        if (
            self.secret_key_of_user is None
            and "secret_key_of_user" in self.model_fields_set
        ):
            _dict["secretKeyOfUser"] = None

        # set to None if secret_key_of_password (nullable) is None
        # and model_fields_set contains the field
        if (
            self.secret_key_of_password is None
            and "secret_key_of_password" in self.model_fields_set
        ):
            _dict["secretKeyOfPassword"] = None

        # set to None if exclude (nullable) is None
        # and model_fields_set contains the field
        if self.exclude is None and "exclude" in self.model_fields_set:
            _dict["exclude"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GitInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "repository": obj.get("repository"),
                "branch": obj.get("branch"),
                "revision": obj.get("revision"),
                "path": obj.get("path"),
                "passwordSecret": obj.get("passwordSecret"),
                "secretKeyOfUser": obj.get("secretKeyOfUser"),
                "secretKeyOfPassword": obj.get("secretKeyOfPassword"),
                "exclude": (
                    obj.get("exclude") if obj.get("exclude") is not None else False
                ),
            }
        )
        return _obj
