# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class GitPassword(BaseModel):
    """
    Pydantic class model representing GitPassword.

    Parameters:
        ```python
        password_secret: Optional[str]
        secret_key_of_user: Optional[str]
        secret_key_of_password: Optional[str]
        ```
        password_secret: Secret containing the credentials of the repository (needed for non public repository which requires authentication).
        secret_key_of_user: The key to use for loading the user name from the secret. The default is &#x60;User&#x60;.
        secret_key_of_password: The key to use for loading the password from the secret. The default is &#x60;Password&#x60;.
    Example:
        ```python
        GitPassword(
            password_secret='my-password-secret',
                        secret_key_of_user='User',
                        secret_key_of_password='Password'
        )
        ```
    """  # noqa: E501

    password_secret: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Secret containing the credentials of the repository (needed for non public repository which requires authentication).",
        alias="passwordSecret",
    )
    secret_key_of_user: Optional[Annotated[str, Field(min_length=1, strict=True)]] = (
        Field(
            default=None,
            description="The key to use for loading the user name from the secret. The default is `User`.",
            alias="secretKeyOfUser",
        )
    )
    secret_key_of_password: Optional[
        Annotated[str, Field(min_length=1, strict=True)]
    ] = Field(
        default=None,
        description="The key to use for loading the password from the secret. The default is `Password`.",
        alias="secretKeyOfPassword",
    )
    __properties: ClassVar[List[str]] = [
        "passwordSecret",
        "secretKeyOfUser",
        "secretKeyOfPassword",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GitPassword from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if password_secret (nullable) is None
        # and model_fields_set contains the field
        if self.password_secret is None and "password_secret" in self.model_fields_set:
            _dict["passwordSecret"] = None

        # set to None if secret_key_of_user (nullable) is None
        # and model_fields_set contains the field
        if (
            self.secret_key_of_user is None
            and "secret_key_of_user" in self.model_fields_set
        ):
            _dict["secretKeyOfUser"] = None

        # set to None if secret_key_of_password (nullable) is None
        # and model_fields_set contains the field
        if (
            self.secret_key_of_password is None
            and "secret_key_of_password" in self.model_fields_set
        ):
            _dict["secretKeyOfPassword"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GitPassword from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "passwordSecret": obj.get("passwordSecret"),
                "secretKeyOfUser": obj.get("secretKeyOfUser"),
                "secretKeyOfPassword": obj.get("secretKeyOfPassword"),
            }
        )
        return _obj
