# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from runai.models.history_record_meta import HistoryRecordMeta
from runai.models.history_record_spec import HistoryRecordSpec
from typing import Optional, Set
from typing_extensions import Self


class HistoryRecord(BaseModel):
    """
    Pydantic class model representing HistoryRecord.

    Parameters:
        ```python
        meta: HistoryRecordMeta
        spec: HistoryRecordSpec
        ```
        meta: See model HistoryRecordMeta for more information.
        spec: See model HistoryRecordSpec for more information.
    Example:
        ```python
        HistoryRecord(
            meta=runai.models.history_record_meta.HistoryRecordMeta(
                    creation_timestamp = '2022-01-01T03:49:52.531Z',
                    type = 'Event', ),
                        spec=runai.models.history_record_spec.HistoryRecord_spec(
                    event = runai.models.event1.Event1(
                        created_at = '2022-01-01T03:49:52.531Z',
                        id = '',
                        type = 'Normal',
                        cluster_id = '71f69d83-ba66-4822-adf5-55ce55efd210',
                        message = 'Started container z',
                        reason = 'Started',
                        source = 'kubelet',
                        involved_object = runai.models.involved_object.InvolvedObject(
                            uid = '',
                            kind = 'Pod',
                            name = 'test-0-1',
                            namespace = 'runai-test', ), ),
                    phase_update = runai.models.phase_update.PhaseUpdate(
                        phase = 'Creating',
                        phase_message = 'Not enough resources in the requested nodepool', ), )
        )
        ```
    """  # noqa: E501

    meta: HistoryRecordMeta
    spec: HistoryRecordSpec
    __properties: ClassVar[List[str]] = ["meta", "spec"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HistoryRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict["meta"] = self.meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spec
        if self.spec:
            _dict["spec"] = self.spec.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HistoryRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "meta": (
                    HistoryRecordMeta.from_dict(obj["meta"])
                    if obj.get("meta") is not None
                    else None
                ),
                "spec": (
                    HistoryRecordSpec.from_dict(obj["spec"])
                    if obj.get("spec") is not None
                    else None
                ),
            }
        )
        return _obj
