# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.host_path_mount_propagation import HostPathMountPropagation
from typing import Optional, Set
from typing_extensions import Self


class HostPath(BaseModel):
    """
    Pydantic class model representing HostPath.

    Parameters:
        ```python
        path: Optional[str]
        read_only: Optional[bool]
        mount_path: Optional[str]
        mount_propagation: Optional[HostPathMountPropagation]
        ```
        path: Local path within the controller to which the host volume will be mapped. (mandatory)
        read_only: Force the volume to be mounted with read-only permissions. Defaults to false. - Default: True
        mount_path: The path that the host volume will be mounted to when in use. (mandatory)
        mount_propagation: See model HostPathMountPropagation for more information.
    Example:
        ```python
        HostPath(
            path='/container/directory',
                        read_only=True,
                        mount_path='/local/directory',
                        mount_propagation='None'
        )
        ```
    """  # noqa: E501

    path: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Local path within the controller to which the host volume will be mapped. (mandatory)",
    )
    read_only: Optional[StrictBool] = Field(
        default=True,
        description="Force the volume to be mounted with read-only permissions. Defaults to false.",
        alias="readOnly",
    )
    mount_path: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="The path that the host volume will be mounted to when in use. (mandatory)",
        alias="mountPath",
    )
    mount_propagation: Optional[HostPathMountPropagation] = Field(
        default=None, alias="mountPropagation"
    )
    __properties: ClassVar[List[str]] = [
        "path",
        "readOnly",
        "mountPath",
        "mountPropagation",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HostPath from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict["path"] = None

        # set to None if read_only (nullable) is None
        # and model_fields_set contains the field
        if self.read_only is None and "read_only" in self.model_fields_set:
            _dict["readOnly"] = None

        # set to None if mount_path (nullable) is None
        # and model_fields_set contains the field
        if self.mount_path is None and "mount_path" in self.model_fields_set:
            _dict["mountPath"] = None

        # set to None if mount_propagation (nullable) is None
        # and model_fields_set contains the field
        if (
            self.mount_propagation is None
            and "mount_propagation" in self.model_fields_set
        ):
            _dict["mountPropagation"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HostPath from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "path": obj.get("path"),
                "readOnly": (
                    obj.get("readOnly") if obj.get("readOnly") is not None else True
                ),
                "mountPath": obj.get("mountPath"),
                "mountPropagation": obj.get("mountPropagation"),
            }
        )
        return _obj
