# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.boolean_rules import BooleanRules
from runai.models.host_path_mount_propagation_rules import HostPathMountPropagationRules
from runai.models.string_rules import StringRules
from typing import Optional, Set
from typing_extensions import Self


class HostPathRules(BaseModel):
    """
    Pydantic class model representing HostPathRules.

    Parameters:
        ```python
        path: Optional[StringRules]
        read_only: Optional[BooleanRules]
        mount_path: Optional[StringRules]
        mount_propagation: Optional[HostPathMountPropagationRules]
        ```
        path: See model StringRules for more information.
        read_only: See model BooleanRules for more information.
        mount_path: See model StringRules for more information.
        mount_propagation: See model HostPathMountPropagationRules for more information.
    Example:
        ```python
        HostPathRules(
            path=runai.models.string_rules.StringRules(),
                        read_only=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, ),
                        mount_path=runai.models.string_rules.StringRules(),
                        mount_propagation=runai.models.host_path_mount_propagation_rules.HostPathMountPropagationRules()
        )
        ```
    """  # noqa: E501

    path: Optional[StringRules] = None
    read_only: Optional[BooleanRules] = Field(default=None, alias="readOnly")
    mount_path: Optional[StringRules] = Field(default=None, alias="mountPath")
    mount_propagation: Optional[HostPathMountPropagationRules] = Field(
        default=None, alias="mountPropagation"
    )
    __properties: ClassVar[List[str]] = [
        "path",
        "readOnly",
        "mountPath",
        "mountPropagation",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HostPathRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of path
        if self.path:
            _dict["path"] = self.path.to_dict()
        # override the default output from pydantic by calling `to_dict()` of read_only
        if self.read_only:
            _dict["readOnly"] = self.read_only.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mount_path
        if self.mount_path:
            _dict["mountPath"] = self.mount_path.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mount_propagation
        if self.mount_propagation:
            _dict["mountPropagation"] = self.mount_propagation.to_dict()
        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict["path"] = None

        # set to None if read_only (nullable) is None
        # and model_fields_set contains the field
        if self.read_only is None and "read_only" in self.model_fields_set:
            _dict["readOnly"] = None

        # set to None if mount_path (nullable) is None
        # and model_fields_set contains the field
        if self.mount_path is None and "mount_path" in self.model_fields_set:
            _dict["mountPath"] = None

        # set to None if mount_propagation (nullable) is None
        # and model_fields_set contains the field
        if (
            self.mount_propagation is None
            and "mount_propagation" in self.model_fields_set
        ):
            _dict["mountPropagation"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HostPathRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "path": (
                    StringRules.from_dict(obj["path"])
                    if obj.get("path") is not None
                    else None
                ),
                "readOnly": (
                    BooleanRules.from_dict(obj["readOnly"])
                    if obj.get("readOnly") is not None
                    else None
                ),
                "mountPath": (
                    StringRules.from_dict(obj["mountPath"])
                    if obj.get("mountPath") is not None
                    else None
                ),
                "mountPropagation": (
                    HostPathMountPropagationRules.from_dict(obj["mountPropagation"])
                    if obj.get("mountPropagation") is not None
                    else None
                ),
            }
        )
        return _obj
