# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.inference_policy_defaults_and_rules_v2_defaults import (
    InferencePolicyDefaultsAndRulesV2Defaults,
)
from runai.models.inference_policy_rules_v2 import InferencePolicyRulesV2
from runai.models.policy_validation_status import PolicyValidationStatus
from typing import Optional, Set
from typing_extensions import Self


class InferencePolicyDefaultsAndRulesV2(BaseModel):
    """
    Pydantic class model representing InferencePolicyDefaultsAndRulesV2.

    Parameters:
        ```python
        defaults: Optional[InferencePolicyDefaultsAndRulesV2Defaults]
        rules: Optional[InferencePolicyRulesV2]
        imposed_assets: Optional[List[str]]
        status: Optional[PolicyValidationStatus]
        ```
        defaults: See model InferencePolicyDefaultsAndRulesV2Defaults for more information.
        rules: See model InferencePolicyRulesV2 for more information.
        imposed_assets: a list of datasource assets to import into the policy. these datasources will be included in any workload that will be created in the scope of the policy.
        status: See model PolicyValidationStatus for more information.
    Example:
        ```python
        InferencePolicyDefaultsAndRulesV2(
            defaults=runai.models.inference_policy_defaults_and_rules_v2_defaults.InferencePolicyDefaultsAndRulesV2_defaults(),
                        rules="example",
                        imposed_assets=[
                    ''
                    ],
                        status=runai.models.policy_validation_status.PolicyValidationStatus(
                    validation = runai.models.policy_validation_status_validation.PolicyValidationStatus_validation(
                        error_message = '', ), )
        )
        ```
    """  # noqa: E501

    defaults: Optional[InferencePolicyDefaultsAndRulesV2Defaults] = None
    rules: Optional[InferencePolicyRulesV2] = None
    imposed_assets: Optional[List[StrictStr]] = Field(
        default=None,
        description="a list of datasource assets to import into the policy. these datasources will be included in any workload that will be created in the scope of the policy.",
        alias="imposedAssets",
    )
    status: Optional[PolicyValidationStatus] = None
    __properties: ClassVar[List[str]] = ["defaults", "rules", "imposedAssets", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InferencePolicyDefaultsAndRulesV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of defaults
        if self.defaults:
            _dict["defaults"] = self.defaults.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rules
        if self.rules:
            _dict["rules"] = self.rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # set to None if defaults (nullable) is None
        # and model_fields_set contains the field
        if self.defaults is None and "defaults" in self.model_fields_set:
            _dict["defaults"] = None

        # set to None if rules (nullable) is None
        # and model_fields_set contains the field
        if self.rules is None and "rules" in self.model_fields_set:
            _dict["rules"] = None

        # set to None if imposed_assets (nullable) is None
        # and model_fields_set contains the field
        if self.imposed_assets is None and "imposed_assets" in self.model_fields_set:
            _dict["imposedAssets"] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict["status"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InferencePolicyDefaultsAndRulesV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "defaults": (
                    InferencePolicyDefaultsAndRulesV2Defaults.from_dict(obj["defaults"])
                    if obj.get("defaults") is not None
                    else None
                ),
                "rules": (
                    InferencePolicyRulesV2.from_dict(obj["rules"])
                    if obj.get("rules") is not None
                    else None
                ),
                "imposedAssets": obj.get("imposedAssets"),
                "status": (
                    PolicyValidationStatus.from_dict(obj["status"])
                    if obj.get("status") is not None
                    else None
                ),
            }
        )
        return _obj
