# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.scope_type2 import ScopeType2
from typing import Optional, Set
from typing_extensions import Self


class InternalDatavolumeCreationFields(BaseModel):
    """
    Pydantic class model representing InternalDatavolumeCreationFields.

    Parameters:
        ```python
        name: str
        scope: ScopeType2
        department_id: str
        cluster_id: str
        description: str
        origin_pvc_name: str
        ```
        name: See model str for more information.
        scope: See model ScopeType2 for more information.
        department_id: The ID of the department that in its namespace the origin pvc is located (mandatory if scope is department)
        cluster_id: The ID of the cluster that in its namespace the origin pvc is located (mandatory if scope is cluster)
        description: See model str for more information.
        origin_pvc_name: The name of the PVC that the datavolume is based on
    Example:
        ```python
        InternalDatavolumeCreationFields(
            name='datavolume-a',
                        scope='cluster',
                        department_id='4500001',
                        cluster_id='cf8c8ea0-94e4-4177-a050-bbf9b10d9cc5',
                        description='Results of experiment X',
                        origin_pvc_name='pvc-a'
        )
        ```
    """  # noqa: E501

    name: Annotated[str, Field(strict=True, max_length=63)]
    scope: ScopeType2
    department_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID of the department that in its namespace the origin pvc is located (mandatory if scope is department)",
        alias="departmentId",
    )
    cluster_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID of the cluster that in its namespace the origin pvc is located (mandatory if scope is cluster)",
        alias="clusterId",
    )
    description: Optional[Annotated[str, Field(strict=True, max_length=127)]] = None
    origin_pvc_name: StrictStr = Field(
        description="The name of the PVC that the datavolume is based on",
        alias="originPvcName",
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "scope",
        "departmentId",
        "clusterId",
        "description",
        "originPvcName",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z][-a-z0-9]{0,62}$", value):
            raise ValueError(
                r"must validate the regular expression /^[a-z][-a-z0-9]{0,62}$/"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InternalDatavolumeCreationFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InternalDatavolumeCreationFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "scope": obj.get("scope"),
                "departmentId": obj.get("departmentId"),
                "clusterId": obj.get("clusterId"),
                "description": obj.get("description"),
                "originPvcName": obj.get("originPvcName"),
            }
        )
        return _obj
