# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class InternalToolType(str, Enum):
    """
    The type of the internal tool. Internal tool runs within the container and exposes ports associated with the tool using NodePort, LoadBalancer or ExternalUrl.

    Allowed enum values:

    JUPYTER_MINUS_NOTEBOOK = 'jupyter-notebook'

    PYCHARM = 'pycharm'

    VISUAL_MINUS_STUDIO_MINUS_CODE = 'visual-studio-code'

    TENSORBOARD = 'tensorboard'

    RSTUDIO = 'rstudio'

    MLFLOW = 'mlflow'

    CUSTOM = 'custom'

    MATLAB = 'matlab'

    CHATBOT_MINUS_UI = 'chatbot-ui'


    Example:
        ```python
        InternalToolType.JUPYTER_MINUS_NOTEBOOK
        InternalToolType.PYCHARM
        InternalToolType.VISUAL_MINUS_STUDIO_MINUS_CODE
        InternalToolType.TENSORBOARD
        InternalToolType.RSTUDIO
        InternalToolType.MLFLOW
        InternalToolType.CUSTOM
        InternalToolType.MATLAB
        InternalToolType.CHATBOT_MINUS_UI
        ```
    """

    JUPYTER_MINUS_NOTEBOOK = "jupyter-notebook"
    PYCHARM = "pycharm"
    VISUAL_MINUS_STUDIO_MINUS_CODE = "visual-studio-code"
    TENSORBOARD = "tensorboard"
    RSTUDIO = "rstudio"
    MLFLOW = "mlflow"
    CUSTOM = "custom"
    MATLAB = "matlab"
    CHATBOT_MINUS_UI = "chatbot-ui"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of InternalToolType from a JSON string"""
        return cls(json.loads(json_str))
