# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self


class JobAdvancedData(BaseModel):
    """
    Pydantic class model representing JobAdvancedData.

    Parameters:
        ```python
        idle_seconds: float
        gr_engine_active: float
        dram_active: float
        sm_active: float
        sm_occupancy: float
        pipe_tensor_active: float
        pipe_fp64_active: float
        pipe_fp32_active: float
        pipe_fp16_active: float
        nvlink_tx_bytes: float
        nvlink_rx_bytes: float
        pcie_tx_bytes: float
        pcie_rx_bytes: float
        ```
        idle_seconds: See model float for more information.
        gr_engine_active: The fraction of time any portion of the graphics or compute engines were active
        dram_active: The fraction of cycles where data was sent to or received from device memory
        sm_active: The fraction of time at least one warp was active on a multiprocessor, averaged over all multiprocessors
        sm_occupancy: The fraction of resident warps on a multiprocessor, relative to the maximum number of concurrent warps supported on a multiprocessor
        pipe_tensor_active: The fraction of cycles the tensor (HMMA / IMMA) pipe was active
        pipe_fp64_active: The fraction of cycles the FP64 (double precision) pipe was active
        pipe_fp32_active: The fraction of cycles the FMA (FP32 (single precision), and integer) pipe was active
        pipe_fp16_active: The fraction of cycles the FP16 (half precision) pipe was active
        nvlink_tx_bytes: The rate of data transmitted over NVLink, not including protocol headers, in bytes per second
        nvlink_rx_bytes: The rate of data received over NVLink, not including protocol headers, in bytes per second
        pcie_tx_bytes: The rate of data transmitted over the PCIe bus, including both protocol headers and data payloads, in bytes per second
        pcie_rx_bytes: The rate of data received over the PCIe bus, including both protocol headers and data payloads, in bytes per second
    Example:
        ```python
        JobAdvancedData(
            idle_seconds=50,
                        gr_engine_active=1.337,
                        dram_active=1.337,
                        sm_active=1.337,
                        sm_occupancy=1.337,
                        pipe_tensor_active=1.337,
                        pipe_fp64_active=1.337,
                        pipe_fp32_active=1.337,
                        pipe_fp16_active=1.337,
                        nvlink_tx_bytes=1.337,
                        nvlink_rx_bytes=1.337,
                        pcie_tx_bytes=1.337,
                        pcie_rx_bytes=1.337
        )
        ```
    """  # noqa: E501

    idle_seconds: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="idleSeconds"
    )
    gr_engine_active: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The fraction of time any portion of the graphics or compute engines were active",
        alias="grEngineActive",
    )
    dram_active: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The fraction of cycles where data was sent to or received from device memory",
        alias="dramActive",
    )
    sm_active: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The fraction of time at least one warp was active on a multiprocessor, averaged over all multiprocessors",
        alias="smActive",
    )
    sm_occupancy: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The fraction of resident warps on a multiprocessor, relative to the maximum number of concurrent warps supported on a multiprocessor",
        alias="smOccupancy",
    )
    pipe_tensor_active: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The fraction of cycles the tensor (HMMA / IMMA) pipe was active",
        alias="pipeTensorActive",
    )
    pipe_fp64_active: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The fraction of cycles the FP64 (double precision) pipe was active",
        alias="pipeFp64Active",
    )
    pipe_fp32_active: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The fraction of cycles the FMA (FP32 (single precision), and integer) pipe was active",
        alias="pipeFp32Active",
    )
    pipe_fp16_active: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The fraction of cycles the FP16 (half precision) pipe was active",
        alias="pipeFp16Active",
    )
    nvlink_tx_bytes: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The rate of data transmitted over NVLink, not including protocol headers, in bytes per second",
        alias="nvlinkTxBytes",
    )
    nvlink_rx_bytes: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The rate of data received over NVLink, not including protocol headers, in bytes per second",
        alias="nvlinkRxBytes",
    )
    pcie_tx_bytes: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The rate of data transmitted over the PCIe bus, including both protocol headers and data payloads, in bytes per second",
        alias="pcieTxBytes",
    )
    pcie_rx_bytes: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The rate of data received over the PCIe bus, including both protocol headers and data payloads, in bytes per second",
        alias="pcieRxBytes",
    )
    __properties: ClassVar[List[str]] = [
        "idleSeconds",
        "grEngineActive",
        "dramActive",
        "smActive",
        "smOccupancy",
        "pipeTensorActive",
        "pipeFp64Active",
        "pipeFp32Active",
        "pipeFp16Active",
        "nvlinkTxBytes",
        "nvlinkRxBytes",
        "pcieTxBytes",
        "pcieRxBytes",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobAdvancedData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobAdvancedData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "idleSeconds": obj.get("idleSeconds"),
                "grEngineActive": obj.get("grEngineActive"),
                "dramActive": obj.get("dramActive"),
                "smActive": obj.get("smActive"),
                "smOccupancy": obj.get("smOccupancy"),
                "pipeTensorActive": obj.get("pipeTensorActive"),
                "pipeFp64Active": obj.get("pipeFp64Active"),
                "pipeFp32Active": obj.get("pipeFp32Active"),
                "pipeFp16Active": obj.get("pipeFp16Active"),
                "nvlinkTxBytes": obj.get("nvlinkTxBytes"),
                "nvlinkRxBytes": obj.get("nvlinkRxBytes"),
                "pcieTxBytes": obj.get("pcieTxBytes"),
                "pcieRxBytes": obj.get("pcieRxBytes"),
            }
        )
        return _obj
