# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.node_affinity import NodeAffinity
from typing import Optional, Set
from typing_extensions import Self


class JobsNodeAffinity(BaseModel):
    """
    Pydantic class model representing JobsNodeAffinity.

    Parameters:
        ```python
        train: NodeAffinity
        interactive: NodeAffinity
        ```
        train: Node affinity configuration for training jobs.
        interactive: Node affinity configuration for interactive jobs.
    Example:
        ```python
        JobsNodeAffinity(
            train=runai.models.node_affinity.NodeAffinity(
                    affinity_type = 'no_limit',
                    selected_types = [
                        runai.models.node_type_for_project.NodeTypeForProject(
                            id = 1.337,
                            name = '', )
                        ], ),
                        interactive=runai.models.node_affinity.NodeAffinity(
                    affinity_type = 'no_limit',
                    selected_types = [
                        runai.models.node_type_for_project.NodeTypeForProject(
                            id = 1.337,
                            name = '', )
                        ], )
        )
        ```
    """  # noqa: E501

    train: Optional[NodeAffinity] = Field(
        default=None, description="Node affinity configuration for training jobs."
    )
    interactive: Optional[NodeAffinity] = Field(
        default=None, description="Node affinity configuration for interactive jobs."
    )
    __properties: ClassVar[List[str]] = ["train", "interactive"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobsNodeAffinity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of train
        if self.train:
            _dict["train"] = self.train.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interactive
        if self.interactive:
            _dict["interactive"] = self.interactive.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobsNodeAffinity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "train": (
                    NodeAffinity.from_dict(obj["train"])
                    if obj.get("train") is not None
                    else None
                ),
                "interactive": (
                    NodeAffinity.from_dict(obj["interactive"])
                    if obj.get("interactive") is not None
                    else None
                ),
            }
        )
        return _obj
