# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class MetricsType(str, Enum):
    """
    specifies what data to request

    Allowed enum values:

    TOTAL_GPU_NODES = 'TOTAL_GPU_NODES'

    GPU_UTILIZATION = 'GPU_UTILIZATION'

    GPU_UTILIZATION_DISTRIBUTION = 'GPU_UTILIZATION_DISTRIBUTION'

    GPU_MEMORY_UTILIZATION = 'GPU_MEMORY_UTILIZATION'

    CPU_UTILIZATION = 'CPU_UTILIZATION'

    CPU_MEMORY_UTILIZATION = 'CPU_MEMORY_UTILIZATION'

    TOTAL_GPU = 'TOTAL_GPU'

    GPU_QUOTA = 'GPU_QUOTA'

    ALLOCATED_GPU = 'ALLOCATED_GPU'

    UNALLOCATED_GPU = 'UNALLOCATED_GPU'

    AVG_WORKLOAD_WAIT_TIME = 'AVG_WORKLOAD_WAIT_TIME'


    Example:
        ```python
        MetricsType.TOTAL_GPU_NODES
        MetricsType.GPU_UTILIZATION
        MetricsType.GPU_UTILIZATION_DISTRIBUTION
        MetricsType.GPU_MEMORY_UTILIZATION
        MetricsType.CPU_UTILIZATION
        MetricsType.CPU_MEMORY_UTILIZATION
        MetricsType.TOTAL_GPU
        MetricsType.GPU_QUOTA
        MetricsType.ALLOCATED_GPU
        MetricsType.UNALLOCATED_GPU
        MetricsType.AVG_WORKLOAD_WAIT_TIME
        ```
    """

    TOTAL_GPU_NODES = "TOTAL_GPU_NODES"
    GPU_UTILIZATION = "GPU_UTILIZATION"
    GPU_UTILIZATION_DISTRIBUTION = "GPU_UTILIZATION_DISTRIBUTION"
    GPU_MEMORY_UTILIZATION = "GPU_MEMORY_UTILIZATION"
    CPU_UTILIZATION = "CPU_UTILIZATION"
    CPU_MEMORY_UTILIZATION = "CPU_MEMORY_UTILIZATION"
    TOTAL_GPU = "TOTAL_GPU"
    GPU_QUOTA = "GPU_QUOTA"
    ALLOCATED_GPU = "ALLOCATED_GPU"
    UNALLOCATED_GPU = "UNALLOCATED_GPU"
    AVG_WORKLOAD_WAIT_TIME = "AVG_WORKLOAD_WAIT_TIME"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of MetricsType from a JSON string"""
        return cls(json.loads(json_str))
