# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class NodeTelemetryType(str, Enum):
    """
    NodeTelemetryType

    Allowed enum values:

    READY_GPU_NODES = 'READY_GPU_NODES'

    READY_GPUS = 'READY_GPUS'

    TOTAL_GPU_NODES = 'TOTAL_GPU_NODES'

    TOTAL_GPUS = 'TOTAL_GPUS'

    IDLE_ALLOCATED_GPUS = 'IDLE_ALLOCATED_GPUS'

    FREE_GPUS = 'FREE_GPUS'

    ALLOCATED_GPUS = 'ALLOCATED_GPUS'

    TOTAL_CPU_CORES = 'TOTAL_CPU_CORES'

    USED_CPU_CORES = 'USED_CPU_CORES'

    ALLOCATED_CPU_CORES = 'ALLOCATED_CPU_CORES'

    TOTAL_GPU_MEMORY_BYTES = 'TOTAL_GPU_MEMORY_BYTES'

    USED_GPU_MEMORY_BYTES = 'USED_GPU_MEMORY_BYTES'

    TOTAL_CPU_MEMORY_BYTES = 'TOTAL_CPU_MEMORY_BYTES'

    USED_CPU_MEMORY_BYTES = 'USED_CPU_MEMORY_BYTES'

    ALLOCATED_CPU_MEMORY_BYTES = 'ALLOCATED_CPU_MEMORY_BYTES'

    FULLY_FREE_GPU_NODES = 'FULLY_FREE_GPU_NODES'


    Example:
        ```python
        NodeTelemetryType.READY_GPU_NODES
        NodeTelemetryType.READY_GPUS
        NodeTelemetryType.TOTAL_GPU_NODES
        NodeTelemetryType.TOTAL_GPUS
        NodeTelemetryType.IDLE_ALLOCATED_GPUS
        NodeTelemetryType.FREE_GPUS
        NodeTelemetryType.ALLOCATED_GPUS
        NodeTelemetryType.TOTAL_CPU_CORES
        NodeTelemetryType.USED_CPU_CORES
        NodeTelemetryType.ALLOCATED_CPU_CORES
        NodeTelemetryType.TOTAL_GPU_MEMORY_BYTES
        NodeTelemetryType.USED_GPU_MEMORY_BYTES
        NodeTelemetryType.TOTAL_CPU_MEMORY_BYTES
        NodeTelemetryType.USED_CPU_MEMORY_BYTES
        NodeTelemetryType.ALLOCATED_CPU_MEMORY_BYTES
        NodeTelemetryType.FULLY_FREE_GPU_NODES
        ```
    """

    READY_GPU_NODES = "READY_GPU_NODES"
    READY_GPUS = "READY_GPUS"
    TOTAL_GPU_NODES = "TOTAL_GPU_NODES"
    TOTAL_GPUS = "TOTAL_GPUS"
    IDLE_ALLOCATED_GPUS = "IDLE_ALLOCATED_GPUS"
    FREE_GPUS = "FREE_GPUS"
    ALLOCATED_GPUS = "ALLOCATED_GPUS"
    TOTAL_CPU_CORES = "TOTAL_CPU_CORES"
    USED_CPU_CORES = "USED_CPU_CORES"
    ALLOCATED_CPU_CORES = "ALLOCATED_CPU_CORES"
    TOTAL_GPU_MEMORY_BYTES = "TOTAL_GPU_MEMORY_BYTES"
    USED_GPU_MEMORY_BYTES = "USED_GPU_MEMORY_BYTES"
    TOTAL_CPU_MEMORY_BYTES = "TOTAL_CPU_MEMORY_BYTES"
    USED_CPU_MEMORY_BYTES = "USED_CPU_MEMORY_BYTES"
    ALLOCATED_CPU_MEMORY_BYTES = "ALLOCATED_CPU_MEMORY_BYTES"
    FULLY_FREE_GPU_NODES = "FULLY_FREE_GPU_NODES"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of NodeTelemetryType from a JSON string"""
        return cls(json.loads(json_str))
