# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.gpu_resource_optimization import GPUResourceOptimization
from runai.models.nodepool_create_response_fields_placement_strategy import (
    NodepoolCreateResponseFieldsPlacementStrategy,
)
from runai.models.nodepool_gpu_network_acceleration_detection import (
    NodepoolGPUNetworkAccelerationDetection,
)
from typing import Optional, Set
from typing_extensions import Self


class NodepoolCreateFields(BaseModel):
    """
    Pydantic class model representing NodepoolCreateFields.

    Parameters:
        ```python
        name: str
        label_key: str
        label_value: str
        cluster_id: str
        over_provisioning_ratio: Optional[int]
        placement_strategy: NodepoolCreateResponseFieldsPlacementStrategy
        gpu_network_acceleration_label_key: Optional[str]
        gpu_network_acceleration_detection: Optional[NodepoolGPUNetworkAccelerationDetection]
        gpu_resource_optimization: Optional[GPUResourceOptimization]
        ```
        name: See model str for more information.
        label_key: Label key for associated nodes to the Node Pool (with value as in labelValue)
        label_value: Label value for associated nodes to the Node Pool (with key as in labelKey)
        cluster_id: See model str for more information.
        over_provisioning_ratio: See model int for more information. - Default: 1
        placement_strategy: See model NodepoolCreateResponseFieldsPlacementStrategy for more information.
        gpu_network_acceleration_label_key: Label key by which to determine GPUNetworkAccelerationDetection nodes
        gpu_network_acceleration_detection: See model NodepoolGPUNetworkAccelerationDetection for more information. - Default: NodepoolGPUNetworkAccelerationDetection.AUTO
        gpu_resource_optimization: See model GPUResourceOptimization for more information.
    Example:
        ```python
        NodepoolCreateFields(
            name='v100',
                        label_key='node-type',
                        label_value='type-x',
                        cluster_id='d73a738f-fab3-430a-8fa3-5241493d7128',
                        over_provisioning_ratio=1,
                        placement_strategy=runai.models.nodepool_create_response_fields_placement_strategy.NodepoolCreateResponseFields_placementStrategy(
                    cpu = 'spread',
                    gpu = 'spread', ),
                        gpu_network_acceleration_label_key='',
                        gpu_network_acceleration_detection='Auto',
                        gpu_resource_optimization=runai.models.gpu_resource_optimization.GPUResourceOptimization(
                    swap_enabled = True,
                    cpu_swap_memory_size = '100G',
                    reserved_gpu_memory_for_swap_operations = '2G',
                    node_level_scheduler_enabled = True, )
        )
        ```
    """  # noqa: E501

    name: Annotated[str, Field(min_length=1, strict=True)]
    label_key: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="Label key for associated nodes to the Node Pool (with value as in labelValue)",
        alias="labelKey",
    )
    label_value: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="Label value for associated nodes to the Node Pool (with key as in labelKey)",
        alias="labelValue",
    )
    cluster_id: StrictStr = Field(alias="clusterId")
    over_provisioning_ratio: Optional[
        Annotated[int, Field(le=5, strict=True, ge=1)]
    ] = Field(default=1, alias="overProvisioningRatio")
    placement_strategy: Optional[NodepoolCreateResponseFieldsPlacementStrategy] = Field(
        default=None, alias="placementStrategy"
    )
    gpu_network_acceleration_label_key: Optional[StrictStr] = Field(
        default=None,
        description="Label key by which to determine GPUNetworkAccelerationDetection nodes",
        alias="gpuNetworkAccelerationLabelKey",
    )
    gpu_network_acceleration_detection: Optional[
        NodepoolGPUNetworkAccelerationDetection
    ] = Field(
        default=NodepoolGPUNetworkAccelerationDetection.AUTO,
        alias="gpuNetworkAccelerationDetection",
    )
    gpu_resource_optimization: Optional[GPUResourceOptimization] = Field(
        default=None, alias="gpuResourceOptimization"
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "labelKey",
        "labelValue",
        "clusterId",
        "overProvisioningRatio",
        "placementStrategy",
        "gpuNetworkAccelerationLabelKey",
        "gpuNetworkAccelerationDetection",
        "gpuResourceOptimization",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NodepoolCreateFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of placement_strategy
        if self.placement_strategy:
            _dict["placementStrategy"] = self.placement_strategy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_resource_optimization
        if self.gpu_resource_optimization:
            _dict["gpuResourceOptimization"] = self.gpu_resource_optimization.to_dict()
        # set to None if over_provisioning_ratio (nullable) is None
        # and model_fields_set contains the field
        if (
            self.over_provisioning_ratio is None
            and "over_provisioning_ratio" in self.model_fields_set
        ):
            _dict["overProvisioningRatio"] = None

        # set to None if gpu_network_acceleration_label_key (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_network_acceleration_label_key is None
            and "gpu_network_acceleration_label_key" in self.model_fields_set
        ):
            _dict["gpuNetworkAccelerationLabelKey"] = None

        # set to None if gpu_network_acceleration_detection (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_network_acceleration_detection is None
            and "gpu_network_acceleration_detection" in self.model_fields_set
        ):
            _dict["gpuNetworkAccelerationDetection"] = None

        # set to None if gpu_resource_optimization (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_resource_optimization is None
            and "gpu_resource_optimization" in self.model_fields_set
        ):
            _dict["gpuResourceOptimization"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NodepoolCreateFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "labelKey": obj.get("labelKey"),
                "labelValue": obj.get("labelValue"),
                "clusterId": obj.get("clusterId"),
                "overProvisioningRatio": (
                    obj.get("overProvisioningRatio")
                    if obj.get("overProvisioningRatio") is not None
                    else 1
                ),
                "placementStrategy": (
                    NodepoolCreateResponseFieldsPlacementStrategy.from_dict(
                        obj["placementStrategy"]
                    )
                    if obj.get("placementStrategy") is not None
                    else None
                ),
                "gpuNetworkAccelerationLabelKey": obj.get(
                    "gpuNetworkAccelerationLabelKey"
                ),
                "gpuNetworkAccelerationDetection": (
                    obj.get("gpuNetworkAccelerationDetection")
                    if obj.get("gpuNetworkAccelerationDetection") is not None
                    else NodepoolGPUNetworkAccelerationDetection.AUTO
                ),
                "gpuResourceOptimization": (
                    GPUResourceOptimization.from_dict(obj["gpuResourceOptimization"])
                    if obj.get("gpuResourceOptimization") is not None
                    else None
                ),
            }
        )
        return _obj
