# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.boolean_rules import BooleanRules
from typing import Optional, Set
from typing_extensions import Self


class NonInferenceSecurityNonOverridableRules(BaseModel):
    """
    Pydantic class model representing NonInferenceSecurityNonOverridableRules.

    Parameters:
        ```python
        allow_privilege_escalation: Optional[BooleanRules]
        host_ipc: Optional[BooleanRules]
        host_network: Optional[BooleanRules]
        ```
        allow_privilege_escalation: See model BooleanRules for more information.
        host_ipc: See model BooleanRules for more information.
        host_network: See model BooleanRules for more information.
    Example:
        ```python
        NonInferenceSecurityNonOverridableRules(
            allow_privilege_escalation=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, ),
                        host_ipc=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, ),
                        host_network=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, )
        )
        ```
    """  # noqa: E501

    allow_privilege_escalation: Optional[BooleanRules] = Field(
        default=None, alias="allowPrivilegeEscalation"
    )
    host_ipc: Optional[BooleanRules] = Field(default=None, alias="hostIpc")
    host_network: Optional[BooleanRules] = Field(default=None, alias="hostNetwork")
    __properties: ClassVar[List[str]] = [
        "allowPrivilegeEscalation",
        "hostIpc",
        "hostNetwork",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NonInferenceSecurityNonOverridableRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of allow_privilege_escalation
        if self.allow_privilege_escalation:
            _dict["allowPrivilegeEscalation"] = (
                self.allow_privilege_escalation.to_dict()
            )
        # override the default output from pydantic by calling `to_dict()` of host_ipc
        if self.host_ipc:
            _dict["hostIpc"] = self.host_ipc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of host_network
        if self.host_network:
            _dict["hostNetwork"] = self.host_network.to_dict()
        # set to None if allow_privilege_escalation (nullable) is None
        # and model_fields_set contains the field
        if (
            self.allow_privilege_escalation is None
            and "allow_privilege_escalation" in self.model_fields_set
        ):
            _dict["allowPrivilegeEscalation"] = None

        # set to None if host_ipc (nullable) is None
        # and model_fields_set contains the field
        if self.host_ipc is None and "host_ipc" in self.model_fields_set:
            _dict["hostIpc"] = None

        # set to None if host_network (nullable) is None
        # and model_fields_set contains the field
        if self.host_network is None and "host_network" in self.model_fields_set:
            _dict["hostNetwork"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NonInferenceSecurityNonOverridableRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "allowPrivilegeEscalation": (
                    BooleanRules.from_dict(obj["allowPrivilegeEscalation"])
                    if obj.get("allowPrivilegeEscalation") is not None
                    else None
                ),
                "hostIpc": (
                    BooleanRules.from_dict(obj["hostIpc"])
                    if obj.get("hostIpc") is not None
                    else None
                ),
                "hostNetwork": (
                    BooleanRules.from_dict(obj["hostNetwork"])
                    if obj.get("hostNetwork") is not None
                    else None
                ),
            }
        )
        return _obj
