# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class OrgUnitMetricType(str, Enum):
    """
    Specify which metric data to request.

    Allowed enum values:

    GPU_QUOTA = 'GPU_QUOTA'

    CPU_QUOTA_MILLICORES = 'CPU_QUOTA_MILLICORES'

    CPU_MEMORY_QUOTA_MB = 'CPU_MEMORY_QUOTA_MB'

    GPU_ALLOCATION = 'GPU_ALLOCATION'

    CPU_ALLOCATION_MILLICORES = 'CPU_ALLOCATION_MILLICORES'

    CPU_MEMORY_ALLOCATION_MB = 'CPU_MEMORY_ALLOCATION_MB'

    GPU_MEMORY_UTILIZATION = 'GPU_MEMORY_UTILIZATION'


    Example:
        ```python
        OrgUnitMetricType.GPU_QUOTA
        OrgUnitMetricType.CPU_QUOTA_MILLICORES
        OrgUnitMetricType.CPU_MEMORY_QUOTA_MB
        OrgUnitMetricType.GPU_ALLOCATION
        OrgUnitMetricType.CPU_ALLOCATION_MILLICORES
        OrgUnitMetricType.CPU_MEMORY_ALLOCATION_MB
        OrgUnitMetricType.GPU_MEMORY_UTILIZATION
        ```
    """

    GPU_QUOTA = "GPU_QUOTA"
    CPU_QUOTA_MILLICORES = "CPU_QUOTA_MILLICORES"
    CPU_MEMORY_QUOTA_MB = "CPU_MEMORY_QUOTA_MB"
    GPU_ALLOCATION = "GPU_ALLOCATION"
    CPU_ALLOCATION_MILLICORES = "CPU_ALLOCATION_MILLICORES"
    CPU_MEMORY_ALLOCATION_MB = "CPU_MEMORY_ALLOCATION_MB"
    GPU_MEMORY_UTILIZATION = "GPU_MEMORY_UTILIZATION"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of OrgUnitMetricType from a JSON string"""
        return cls(json.loads(json_str))
