# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self


class OvertimeRangeData(BaseModel):
    """
    Pydantic class model representing Average data for the specified time range, or for the lifetime of the project/department if it exists for less than the time range..

    Parameters:
        ```python
        average_gpu_allocation: float
        average_gpu_utilization: float
        average_gpu_memory_utilization: Optional[float]
        updated_at: datetime
        ```
        average_gpu_allocation: The average gpu devices allocation of the project/department.
        average_gpu_utilization: The average gpu utilization percentage of the project/department.
        average_gpu_memory_utilization: The average gpu memory utilization percentage of the project/department. Only available for cluster versions &gt;&#x3D; 2.22.
        updated_at: See model datetime for more information.
    Example:
        ```python
        OvertimeRangeData(
            average_gpu_allocation=10,
                        average_gpu_utilization=95,
                        average_gpu_memory_utilization=95,
                        updated_at='2021-08-01T00:00Z'
        )
        ```
    """  # noqa: E501

    average_gpu_allocation: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The average gpu devices allocation of the project/department.",
        alias="averageGpuAllocation",
    )
    average_gpu_utilization: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The average gpu utilization percentage of the project/department.",
        alias="averageGpuUtilization",
    )
    average_gpu_memory_utilization: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The average gpu memory utilization percentage of the project/department. Only available for cluster versions >= 2.22.",
        alias="averageGpuMemoryUtilization",
    )
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    __properties: ClassVar[List[str]] = [
        "averageGpuAllocation",
        "averageGpuUtilization",
        "averageGpuMemoryUtilization",
        "updatedAt",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OvertimeRangeData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if average_gpu_memory_utilization (nullable) is None
        # and model_fields_set contains the field
        if (
            self.average_gpu_memory_utilization is None
            and "average_gpu_memory_utilization" in self.model_fields_set
        ):
            _dict["averageGpuMemoryUtilization"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OvertimeRangeData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "averageGpuAllocation": obj.get("averageGpuAllocation"),
                "averageGpuUtilization": obj.get("averageGpuUtilization"),
                "averageGpuMemoryUtilization": obj.get("averageGpuMemoryUtilization"),
                "updatedAt": obj.get("updatedAt"),
            }
        )
        return _obj
