# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.org_type import OrgType
from runai.models.phase_reason import PhaseReason
from typing import Optional, Set
from typing_extensions import Self


class PendingSchedulingMessage(BaseModel):
    """
    Pydantic class model representing PendingSchedulingMessage.

    Parameters:
        ```python
        node_pool: str
        phase_reason: PhaseReason
        reason: str
        org_type: Optional[OrgType]
        user_message: Optional[str]
        ```
        node_pool: See model str for more information.
        phase_reason: See model PhaseReason for more information.
        reason: See model str for more information.
        org_type: See model OrgType for more information.
        user_message: See model str for more information.
    Example:
        ```python
        PendingSchedulingMessage(
            node_pool='default',
                        phase_reason='NonPreemptibleOverQuota',
                        reason='Non-preemptible over quota',
                        org_type='PROJECT',
                        user_message='You have reached the limit of non-preemptible resources'
        )
        ```
    """  # noqa: E501

    node_pool: StrictStr = Field(alias="nodePool")
    phase_reason: PhaseReason = Field(alias="phaseReason")
    reason: StrictStr
    org_type: Optional[OrgType] = Field(default=None, alias="orgType")
    user_message: Optional[StrictStr] = Field(default=None, alias="userMessage")
    __properties: ClassVar[List[str]] = [
        "nodePool",
        "phaseReason",
        "reason",
        "orgType",
        "userMessage",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PendingSchedulingMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if org_type (nullable) is None
        # and model_fields_set contains the field
        if self.org_type is None and "org_type" in self.model_fields_set:
            _dict["orgType"] = None

        # set to None if user_message (nullable) is None
        # and model_fields_set contains the field
        if self.user_message is None and "user_message" in self.model_fields_set:
            _dict["userMessage"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PendingSchedulingMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "nodePool": obj.get("nodePool"),
                "phaseReason": obj.get("phaseReason"),
                "reason": obj.get("reason"),
                "orgType": obj.get("orgType"),
                "userMessage": obj.get("userMessage"),
            }
        )
        return _obj
