# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class PodMetricType(str, Enum):
    """
    Specify which data to request.

    Allowed enum values:

    GPU_UTILIZATION_PER_GPU = 'GPU_UTILIZATION_PER_GPU'

    GPU_UTILIZATION = 'GPU_UTILIZATION'

    GPU_MEMORY_USAGE_BYTES_PER_GPU = 'GPU_MEMORY_USAGE_BYTES_PER_GPU'

    GPU_MEMORY_USAGE_BYTES = 'GPU_MEMORY_USAGE_BYTES'

    CPU_USAGE_CORES = 'CPU_USAGE_CORES'

    CPU_MEMORY_USAGE_BYTES = 'CPU_MEMORY_USAGE_BYTES'

    GPU_GRAPHICS_ENGINE_ACTIVITY_PER_GPU = 'GPU_GRAPHICS_ENGINE_ACTIVITY_PER_GPU'

    GPU_SM_ACTIVITY_PER_GPU = 'GPU_SM_ACTIVITY_PER_GPU'

    GPU_SM_OCCUPANCY_PER_GPU = 'GPU_SM_OCCUPANCY_PER_GPU'

    GPU_TENSOR_ACTIVITY_PER_GPU = 'GPU_TENSOR_ACTIVITY_PER_GPU'

    GPU_FP64_ENGINE_ACTIVITY_PER_GPU = 'GPU_FP64_ENGINE_ACTIVITY_PER_GPU'

    GPU_FP32_ENGINE_ACTIVITY_PER_GPU = 'GPU_FP32_ENGINE_ACTIVITY_PER_GPU'

    GPU_FP16_ENGINE_ACTIVITY_PER_GPU = 'GPU_FP16_ENGINE_ACTIVITY_PER_GPU'

    GPU_MEMORY_BANDWIDTH_UTILIZATION_PER_GPU = 'GPU_MEMORY_BANDWIDTH_UTILIZATION_PER_GPU'

    GPU_NVLINK_TRANSMITTED_BANDWIDTH_PER_GPU = 'GPU_NVLINK_TRANSMITTED_BANDWIDTH_PER_GPU'

    GPU_NVLINK_RECEIVED_BANDWIDTH_PER_GPU = 'GPU_NVLINK_RECEIVED_BANDWIDTH_PER_GPU'

    GPU_PCIE_TRANSMITTED_BANDWIDTH_PER_GPU = 'GPU_PCIE_TRANSMITTED_BANDWIDTH_PER_GPU'

    GPU_PCIE_RECEIVED_BANDWIDTH_PER_GPU = 'GPU_PCIE_RECEIVED_BANDWIDTH_PER_GPU'

    GPU_SWAP_MEMORY_BYTES_PER_GPU = 'GPU_SWAP_MEMORY_BYTES_PER_GPU'


    Example:
        ```python
        PodMetricType.GPU_UTILIZATION_PER_GPU
        PodMetricType.GPU_UTILIZATION
        PodMetricType.GPU_MEMORY_USAGE_BYTES_PER_GPU
        PodMetricType.GPU_MEMORY_USAGE_BYTES
        PodMetricType.CPU_USAGE_CORES
        PodMetricType.CPU_MEMORY_USAGE_BYTES
        PodMetricType.GPU_GRAPHICS_ENGINE_ACTIVITY_PER_GPU
        PodMetricType.GPU_SM_ACTIVITY_PER_GPU
        PodMetricType.GPU_SM_OCCUPANCY_PER_GPU
        PodMetricType.GPU_TENSOR_ACTIVITY_PER_GPU
        PodMetricType.GPU_FP64_ENGINE_ACTIVITY_PER_GPU
        PodMetricType.GPU_FP32_ENGINE_ACTIVITY_PER_GPU
        PodMetricType.GPU_FP16_ENGINE_ACTIVITY_PER_GPU
        PodMetricType.GPU_MEMORY_BANDWIDTH_UTILIZATION_PER_GPU
        PodMetricType.GPU_NVLINK_TRANSMITTED_BANDWIDTH_PER_GPU
        PodMetricType.GPU_NVLINK_RECEIVED_BANDWIDTH_PER_GPU
        PodMetricType.GPU_PCIE_TRANSMITTED_BANDWIDTH_PER_GPU
        PodMetricType.GPU_PCIE_RECEIVED_BANDWIDTH_PER_GPU
        PodMetricType.GPU_SWAP_MEMORY_BYTES_PER_GPU
        ```
    """

    GPU_UTILIZATION_PER_GPU = "GPU_UTILIZATION_PER_GPU"
    GPU_UTILIZATION = "GPU_UTILIZATION"
    GPU_MEMORY_USAGE_BYTES_PER_GPU = "GPU_MEMORY_USAGE_BYTES_PER_GPU"
    GPU_MEMORY_USAGE_BYTES = "GPU_MEMORY_USAGE_BYTES"
    CPU_USAGE_CORES = "CPU_USAGE_CORES"
    CPU_MEMORY_USAGE_BYTES = "CPU_MEMORY_USAGE_BYTES"
    GPU_GRAPHICS_ENGINE_ACTIVITY_PER_GPU = "GPU_GRAPHICS_ENGINE_ACTIVITY_PER_GPU"
    GPU_SM_ACTIVITY_PER_GPU = "GPU_SM_ACTIVITY_PER_GPU"
    GPU_SM_OCCUPANCY_PER_GPU = "GPU_SM_OCCUPANCY_PER_GPU"
    GPU_TENSOR_ACTIVITY_PER_GPU = "GPU_TENSOR_ACTIVITY_PER_GPU"
    GPU_FP64_ENGINE_ACTIVITY_PER_GPU = "GPU_FP64_ENGINE_ACTIVITY_PER_GPU"
    GPU_FP32_ENGINE_ACTIVITY_PER_GPU = "GPU_FP32_ENGINE_ACTIVITY_PER_GPU"
    GPU_FP16_ENGINE_ACTIVITY_PER_GPU = "GPU_FP16_ENGINE_ACTIVITY_PER_GPU"
    GPU_MEMORY_BANDWIDTH_UTILIZATION_PER_GPU = (
        "GPU_MEMORY_BANDWIDTH_UTILIZATION_PER_GPU"
    )
    GPU_NVLINK_TRANSMITTED_BANDWIDTH_PER_GPU = (
        "GPU_NVLINK_TRANSMITTED_BANDWIDTH_PER_GPU"
    )
    GPU_NVLINK_RECEIVED_BANDWIDTH_PER_GPU = "GPU_NVLINK_RECEIVED_BANDWIDTH_PER_GPU"
    GPU_PCIE_TRANSMITTED_BANDWIDTH_PER_GPU = "GPU_PCIE_TRANSMITTED_BANDWIDTH_PER_GPU"
    GPU_PCIE_RECEIVED_BANDWIDTH_PER_GPU = "GPU_PCIE_RECEIVED_BANDWIDTH_PER_GPU"
    GPU_SWAP_MEMORY_BYTES_PER_GPU = "GPU_SWAP_MEMORY_BYTES_PER_GPU"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PodMetricType from a JSON string"""
        return cls(json.loads(json_str))
